package com.yeejoin.amos.boot.module.common.biz.refresh;

import lombok.Getter;
import org.springframework.context.ApplicationEvent;

import java.util.List;

@Getter
public class DataRefreshEvent extends ApplicationEvent {

    /**
     * 业务数据ID：设备record、企业的id、人员的id
     */
    private final List<String> dataIds;

    /**
     * 数据类型
     */
    private final String dataType;

    /**
     * 操作类型(INSERT/UPDATE/DELETE)--暂无用途
     */
    private final Operation operation;

    /**
     * Create a new {@code ApplicationEvent}.
     *
     * @param source the object on which the event initially occurred or with
     *               which the event is associated (never {@code null})
     */
    public DataRefreshEvent(Object source, List<String> dataIds, String dataType, Operation operation) {
        super(source);
        this.dataIds = dataIds;
        this.dataType = dataType;
        this.operation = operation;
    }

    public enum Operation {
        INSERT,
        UPDATE,
        DELETE
    }

    public enum DataType {
        equipment,
        enterprise,
        user
    }
}
