package com.yeejoin.amos.boot.module.tcm.api.dto;

import com.alibaba.fastjson.JSONArray;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.tcm.api.entity.RiskProcesses;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 风险报送表
 *
 * @author system_generator
 * @date 2025-08-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "RiskReportDto", description = "风险报送表")
public class RiskReportDto extends BaseDto {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "报送编号")
    private String reportNo;

    @ApiModelProperty(value = "风险类型code")
    private String riskTypeCode;

    @ApiModelProperty(value = "风险类型名称")
    private String riskTypeName;

    @ApiModelProperty(value = "报送单位seq")
    private String reportCompanySeq;

    @ApiModelProperty(value = "报送单位code")
    private String reportCompanyCode;

    @ApiModelProperty(value = "报送单位name")
    private String reportCompanyName;

    @ApiModelProperty(value = "风险企业seq")
    private String riskCompanySeq;

    @ApiModelProperty(value = "风险企业code")
    private String riskCompanyCode;

    @ApiModelProperty(value = "风险企业name")
    private String riskCompanyName;

    @ApiModelProperty(value = "风险处置单位seq")
    private String riskDisposalUnitSeq;

    @ApiModelProperty(value = "风险处置单位code")
    private String riskDisposalUnitCode;

    @ApiModelProperty(value = "风险处置单位name")
    private String riskDisposalUnitName;

    @ApiModelProperty(value = "风险处置单位orgCode（考虑到转办，当前单位和此orgCode相同才有处置权限，转办会更新此三项）")
    private String riskDisposalUnitOrgCode;

    @ApiModelProperty(value = "经手的风险处置单位orgCode（转办会增加此项内容）")
    private String allRiskDisposalUnitOrgCode;

    @ApiModelProperty(value = "风险关联设备recod(目前没用到，冗余)")
    private String riskEquipRecord;

    @ApiModelProperty(value = "操作人userId")
    private String operationUserId;

    @ApiModelProperty(value = "风险正文-标题")
    private String riskMainTitle;

    @ApiModelProperty(value = "风险正文-内容")
    private String riskMainContent;

    @ApiModelProperty(value = "风险正文-附件")
    private JSONArray riskMainFile;

    @ApiModelProperty(value = "报送员userId")
    private String reportUserId;

    @ApiModelProperty(value = "报送员userName")
    private String reportUserName;

    @ApiModelProperty(value = "报送员phone")
    private String reportUserPhone;

    @ApiModelProperty(value = "当前阶段（草稿/监管处置/企业整改）")
    private String currentStage;

    @ApiModelProperty(value = "当前状态（草稿/待处理/待整改/待确认/已办理）")
    private String currentStatus;

    @ApiModelProperty(value = "处置结束时间")
    private Date endDate;

    @ApiModelProperty(value = "创建时间")
    private Date createDate;

    @ApiModelProperty(value = "创建人id")
    private String createUserId;

    @ApiModelProperty(value = "创建人")
    private String createUserName;

    @ApiModelProperty(value = "登录人所在单位类型/监管supervision/企业company")
    private String unitType;

    @ApiModelProperty(value = "暂存or提交标志")
    private Boolean submitFlag;

    @ApiModelProperty(value = "报送单位Name-搜索用")
    private String reportCompanyNameWithSearch;

    @ApiModelProperty(value = "风险企业")
    private String riskCompany;

    @ApiModelProperty(value = "风险处置单位")
    private String riskDisposalUnit;

    @ApiModelProperty(value = "风险处置单位")
    private List<RiskProcesses> riskProcesses;

    @ApiModelProperty(value = "是否显示【确认已处置】")
    private Boolean showConfirmDisposal = false;

}
