package com.yeejoin.amos.boot.module.tcm.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

@AllArgsConstructor
@Getter
public enum SupervisoryEnum {

        /**
         * 监管单位层级
         */
        // 省
        PROVINCE("headquarter","prefecture-level"),
        // 市
        CITY("prefecture-level", "county"),
        // 区县
        DISTRICT("county", "organization"),
        // 所
        PLACE("organization", "organization");

        String level;
        String nextLevel;

        public static SupervisoryEnum getEnumByLevel(String level) {
            for (SupervisoryEnum value : SupervisoryEnum.values()) {
                if (value.getLevel().equals(level)) {
                    return value;
                }
            }
            return null;
        }
    }
