package com.yeejoin.amos.boot.module.common.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.*;

@Getter
@AllArgsConstructor
public enum ZBGLEnum {
    YJCZ("应急处置","yjcz",true,null,"",false),
    DTGZYYZBFX("电梯故障原因占比分析","dtgzyyzbfx",false,"yjcz","dtgzyyzbfxServiceImpl",false),
    DTKRSJCSFX("电梯困人事件场所分布","dtkrsjcsfx",false,"yjcz","dtkrsjcsfxServiceImpl",false),
    KRJYYDQK("困人救援月度情况","krjyydqk",false,"yjcz","krjyydqkServiceImpl",false),
    JDGL("监督管理","jdgl",true,null,"",false),
    YWBLPJSXTJ("业务办理平均时效统计","ywblpjsxtj",false,"jdgl","ywblpjsxtjServiceImpl",false),
    AQZS("安全追溯","aqzs",true,null,"",false),
//    YHSLQS("隐患数量趋势（近12个月）","yhslqs",false,"aqzs","",false),
    AYHLXYHSLPM("按隐患类型隐患数量排名（Top10）","ayhlxyhslpm",false,"aqzs","ayhlxyhslpmServiceImpl",false),
    DNZTDWYHPM("当年主体单位隐患排名（Top10）","dnztdwyhpm",false,"aqzs","dnztdwyhpmServiceImpl",true),
    QP("气瓶","qp",true,null,"",false),
    QYAQZSTJ("区域安全指数统计","qyaqzstj",false,"qp","qyaqzstjServiceImpl",false),

    ;

    String name;
    String code;
    Boolean isMainBody;
    String mainBody;
    String className;
    Boolean havePage;

    public static List<Map<String,Object>> getEnumList() {
        List<Map<String,Object>> result = new ArrayList<>();
        for (ZBGLEnum zbglEnum : EnumSet.allOf(ZBGLEnum.class)) {
            if(zbglEnum.isMainBody){
                HashMap<String,Object> map = new HashMap<>();
                map.put("title",zbglEnum.name);
                map.put("value",zbglEnum.code);
                List<Map<String,Object>> childrenList = new ArrayList<>();
                for (ZBGLEnum childrenEnum : EnumSet.allOf(ZBGLEnum.class)) {
                    if(!childrenEnum.isMainBody && childrenEnum.mainBody.equals(zbglEnum.code)){
                        HashMap<String,Object> childrenMap = new HashMap<>();
                        childrenMap.put("title",childrenEnum.name);
                        childrenMap.put("value",childrenEnum.code);
                        childrenMap.put("havePage",childrenEnum.havePage);
                        childrenList.add(childrenMap);
                    }
                }
                map.put("children",childrenList);
                result.add(map);
            }
        }
        return result;
    }
}
