package com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.newProject;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.biz.common.entity.TzsBaseEntity;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.equip.CommonEquipDataProcessService;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.IdxBizJgUseInfoServiceImpl;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgProjectContraption;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgUseInfo;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Service
@RequiredArgsConstructor
@Getter
public class NewProjectEditUpdateService {
    private final IdxBizJgUseInfoServiceImpl useInfoService;

    private final CommonEquipDataProcessService commonEquipDataProcessService;

    public Set<String> getEqsByProjectContraptionId(String projectContraptionId) {
        List<IdxBizJgUseInfo> useInfos = useInfoService.list(new LambdaQueryWrapper<IdxBizJgUseInfo>().eq(IdxBizJgUseInfo::getProjectContraptionId, projectContraptionId).select(IdxBizJgUseInfo::getRecord));
        return useInfos.stream().map(IdxBizJgUseInfo::getRecord).collect(Collectors.toSet());
    }

    public void updateBizInfo(String projectContraptionId) {
        IdxBizJgProjectContraption projectContraption = commonEquipDataProcessService.getIdxBizJgProjectContraptionServiceImpl().getOne(new LambdaQueryWrapper<IdxBizJgProjectContraption>().eq(BaseEntity::getSequenceNbr, projectContraptionId).select(BaseEntity::getSequenceNbr, IdxBizJgProjectContraption::getUseRegistrationCode));
        // 按照装置id查询装置下管道，更新为已纳管状态写入使用登记证编号
        List<IdxBizJgUseInfo> useInfos = useInfoService.list(new LambdaQueryWrapper<IdxBizJgUseInfo>()
                .eq(IdxBizJgUseInfo::getProjectContraptionId, projectContraptionId)
                //.eq(IdxBizJgUseInfo::getIsIntoManagement, false)修改已纳管管道编辑使用登记证号，不更新bug
                .select(IdxBizJgUseInfo::getRecord, TzsBaseEntity::getSequenceNbr));
        useInfos.forEach(e -> {
            commonEquipDataProcessService.setNewPipelineUseState(e, projectContraption.getUseRegistrationCode());
            commonEquipDataProcessService.updateUseOrgCode2NewPipeline(e, projectContraption.getUseRegistrationCode());
        });
    }
}
