package com.yeejoin.amos.boot.module.tcm.api.enums;

import lombok.Getter;

/**
 * 业务类型枚举
 *
 * @author Administrator
 */
@Getter
public enum SafetyProblemStatusEnum {

    /**
     * 问题主体类型
     */
    UNHANDLED("0", "未处理", "red"),

    HANDLED("1", "已处理", "green");

    private final String code;

    private final String name;

    private final String color;

    SafetyProblemStatusEnum(String code, String name, String color) {
        this.code = code;
        this.name = name;
        this.color = color;
    }

    public static String getNameByType(String code) {
        String name = null;
        for (SafetyProblemStatusEnum enumOne : SafetyProblemStatusEnum.values()) {
            if (enumOne.getCode().equals(code)) {
                name = enumOne.getName();
                break;
            }
        }
        return name;
    }
}
