package com.yeejoin.amos.boot.module.ymt.flc.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.module.ymt.biz.utils.BeanDtoVoUtils;
import com.yeejoin.amos.boot.module.ymt.flc.api.dto.EquipmentDto;
import com.yeejoin.amos.boot.module.ymt.flc.api.entity.Equipment;
import com.yeejoin.amos.boot.module.ymt.flc.api.entity.EquipmentAssociated;
import com.yeejoin.amos.boot.module.ymt.flc.biz.service.impl.EquipmentAssociatedServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.util.ArrayList;
import java.util.List;

import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ymt.flc.api.dto.EquipmentAssociatedDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 配套设备/设施/部件
 *
 * @author system_generator
 * @date 2021-11-26
 */
@RestController
@Api(tags = "配套设备设施部件Api")
@RequestMapping(value = "/equipment-associated")
public class EquipmentAssociatedController extends BaseController {

    @Autowired
    EquipmentAssociatedServiceImpl equipmentAssociatedServiceImpl;

    /**
     * 新增配套设备/设施/部件
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增配套设备设施部件", notes = "新增配套设备设施部件")
	public ResponseModel<EquipmentAssociatedDto> save(@RequestBody EquipmentAssociatedDto model) {
		model.setIsDelete(false);
	    model = equipmentAssociatedServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
	 * 根据sequenceNbr删除
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@DeleteMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "DELETE", value = "删除配套设施", notes = "删除配套设施")
	public ResponseModel<Boolean> deleteBySequenceNbr(@PathVariable(value = "sequenceNbr") Long sequenceNbr){
		Boolean flag = equipmentAssociatedServiceImpl.update(new LambdaUpdateWrapper<EquipmentAssociated>().eq(EquipmentAssociated::getSequenceNbr,sequenceNbr).set(EquipmentAssociated::getIsDelete,true));
		return ResponseHelper.buildResponse(flag);
	}


	/**
	 * 根据sequenceNbr更新
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/updateAssociated")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新配套设备设施部件", notes = "根据sequenceNbr配套设备设施部件")
	public ResponseModel<EquipmentAssociatedDto> updateAssociated(@RequestBody EquipmentAssociatedDto model) {
		if (ValidationUtil.isEmpty(model)
				|| ValidationUtil.isEmpty(model.getSequenceNbr())) {
			throw new BadRequest("参数校验失败.");
		}
		model = equipmentAssociatedServiceImpl.updateAssociated(model);
		return ResponseHelper.buildResponse(model);
	}



	/**
	 * 新增配套设备/设施/部件
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET", value = "根据设备id返回配套设施信息", notes = "根据设备id返回配套设施信息")
	public ResponseModel<List<EquipmentAssociatedDto>> getAssociatedByEquipmentId(@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
		List<EquipmentAssociated> entity = equipmentAssociatedServiceImpl.list(new LambdaQueryWrapper<EquipmentAssociated>().eq(EquipmentAssociated::getIsDelete,false).eq(EquipmentAssociated::getEquipmentId,sequenceNbr));
		List<EquipmentAssociatedDto> result = new ArrayList<>();
		entity.stream().forEach(t -> {
			EquipmentAssociatedDto temp = new EquipmentAssociatedDto();
			BeanUtils.copyProperties(t,temp);
			result.add(temp);
		});

		return ResponseHelper.buildResponse(result);
	}


	/**
	 *
	 * @param pageNum
	 * @param pageSize
	 * @param equipId
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "配套设备设施部件分页查询",  notes = "配套设备设施部件分页查询")
	public ResponseModel<IPage<EquipmentAssociatedDto>> queryForPage(String pageNum, String pageSize, @RequestParam (value = "equipId") Long equipId) {
		Page<EquipmentAssociated> pageBean;
		IPage<EquipmentAssociated> page;
		LambdaQueryWrapper<EquipmentAssociated> queryWrapper = new LambdaQueryWrapper<EquipmentAssociated>().eq(EquipmentAssociated::getIsDelete,false).eq(EquipmentAssociated::getEquipmentId,equipId);
		if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
			pageBean = new Page<>(0, Long.MAX_VALUE);
		} else {
			pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
		}
		page = equipmentAssociatedServiceImpl.page(pageBean, queryWrapper);
		int num= equipmentAssociatedServiceImpl.count(queryWrapper);
		pageBean.setTotal(num);
		IPage<EquipmentAssociatedDto> result = BeanDtoVoUtils.iPageVoStream(page,EquipmentAssociatedDto.class);
		return ResponseHelper.buildResponse(result);
	}


}
