package com.yeejoin.amos.boot.module.jg.biz.reminder.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jg.biz.reminder.core.IReminderHandler;
import com.yeejoin.amos.boot.module.jg.biz.reminder.biz.factory.ReminderFactory;
import com.yeejoin.amos.boot.module.jg.api.dto.ReminderItemDto;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Map;

@Service
@RequiredArgsConstructor
public class RemindServiceImpl {

    @Value("${grade.calculation.strategy:MAX_GRADE}")
    private String activeStrategy;

    private final ReminderFactory reminderFactory;

    public IPage<ReminderItemDto> getReminderItems(Page<ReminderItemDto> page, String bizId, String bizType, IReminderHandler.SourceType sourceType, Map<String, Object> formData) {
        return reminderFactory.getReminderHandler(bizType).getReminderList(page, StringUtils.isEmpty(bizId) ? null : bizId, sourceType, formData);
    }

    public Integer getReminderLevel(String bizId, String bizType) {
        return reminderFactory.getReminderHandler(bizType).getReminderLevel(bizId, activeStrategy);
    }
}
