package com.yeejoin.amos.boot.module.cylinder.flc.biz.controller;


import com.yeejoin.amos.boot.module.cylinder.flc.biz.service.impl.CylSyncServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

@RestController
@Api(tags = "气瓶同步Api")
@RequestMapping(value = "/cyl")
public class CylSyncController {

    @Autowired
    private CylSyncServiceImpl cylSyncService;

    /**
     * test
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "test", notes = "test")
    @GetMapping(value = "/sync/test")
    public ResponseModel<String> testSync(){
        cylSyncService.syncFillingCheckInfo();
        return ResponseHelper.buildResponse("ok");
    }





    /**
     * test
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "cylinderInfo", notes = "cylinderInfo")
    @GetMapping(value = "/sync/cylinderInfo")
    public ResponseModel<Object> cylinderInfo(){
        return ResponseHelper.buildResponse(cylSyncService.cylinderInfo());
    }

    /**
     * 同步cylinder_filling表
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET",value = "Filling表同步", notes = "Filling表同步")
    @GetMapping(value = "/sync/Filling")
    public ResponseModel<Object> synchronizationFilling(){
        return ResponseHelper.buildResponse(cylSyncService.fillingSync());
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "充装记录同步", notes = "充装记录同步")
    @GetMapping(value = "/sync/fillingRecordSync")
    public ResponseModel<Object> fillingRecordSync(){
        return ResponseHelper.buildResponse(cylSyncService.fillingRecordSync());
    }
}
