package com.yeejoin.amos.boot.module.jg.api.vo.tableDataExportVo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.yeejoin.amos.boot.module.jg.api.annotation.DictCode2DictName;
import lombok.Data;

import java.util.Date;

/**
 * 人员列表
 */
@Data
public class UserInfoVo {

    @ExcelProperty("姓名")
    private String name;

    @ExcelProperty("证件类型")
    @DictCode2DictName(type = "ZJLX", typeHandler = "cbDataDictTypeHandler")
    private String certificateType;

    @ExcelProperty("证件编号")
    private String certificateNum;

    @ExcelProperty("性别")
    private String gender;

    @ExcelProperty("岗位名称")
    private String postName;

    @ExcelProperty(value = "岗位子类型名称")
    private String subPostName;

    @ExcelProperty("联系电话")
    private String phone;

    @ExcelProperty("出生日期")
    private Date birthday;

    @ExcelProperty("学历")
    @DictCode2DictName(type = "QYRYXL", typeHandler = "cbDataDictTypeHandler")
    private String education;

    @ExcelProperty("专业")
    private String speciality;

    @ExcelProperty("邮箱")
    private String email;

    @ExcelProperty("住址")
    private String address;

    @ExcelProperty("平台账户名")
    private String amosUserName;

    @ExcelProperty("单位名称")
    private String unitName;

    @ExcelProperty("企业编码")
    private String unitCode;

    @ExcelProperty("平台账号id")
    private String amosUserId;

    @ExcelProperty("平台账号锁定状态")
    private String lockStatus;

    @ExcelProperty(value = "检验检测-资质数据")
    private String permissionData;

    @ExcelProperty(value = "职称")
    private String jobTitle;
    
    @ExcelProperty(value = "人员是否转出")
    protected String transferOut;

    @ExcelProperty(value = "人员转出时间")
    protected Date transferOutTime;

    @ExcelProperty("检验检测-级别")
    @DictCode2DictName(type = "RYJB_JC", typeHandler = "platformDictTypeHandler")
    private String permissionLevel;

    @ExcelProperty("检验检测-资质项目")
    private String permissionItem;

    @ExcelProperty("证书编号")
    private String certNo;

    @ExcelProperty("有效期至")
    private Date expiryDate;

    @ExcelProperty("发证机关")
    private String approvedOrgan;

    @ExcelProperty("发证日期")
    private Date issueDate;

    @ExcelProperty("证书类型")
    private String certType;

    @ExcelProperty("作业项目")
    private String jobItem;

    @ExcelProperty("其他作业项目")
    private String otherItem;

    @ExcelProperty("备注")
    private String remark;
}
