package com.yeejoin.amos.boot.module.jg.biz.controller;


import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jg.biz.service.ICommonService;
import com.yeejoin.amos.boot.module.ymt.api.entity.EquipmentCategory;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javafx.scene.chart.ValueAxis;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 装备分类
 *
 * @author system_generator
 * @date 2021-10-20
 */
@RestController
@Api(tags = "装备分类Api")
@RequestMapping(value = "/common")
public class CommonController extends BaseController {
	@Autowired
	ICommonService commonService;

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getChildren")
	@ApiOperation(httpMethod = "GET", value = "通过设备种类code获取设备类别", notes = "通过设备种类code获取设备类别")
	public ResponseModel<List<EquipmentCategory>> getChildren(@RequestParam(value = "code") String code,
															  @RequestParam(value = "type", required = false) String type) {
		return ResponseHelper.buildResponse(commonService.getEquipmentCategoryList(code, type));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getRegion")
	@ApiOperation(httpMethod = "GET", value = "获取行政区划", notes = "获取行政区划")
	public ResponseModel<Object> getRegion(@RequestParam(value = "level", required = false) String level,
										   @RequestParam(value = "parentId", required = false) String parentId) {
		return ResponseHelper.buildResponse(commonService.getRegion(level, parentId));
	}

	/**
	 * 获取管辖分局树
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/creatTree")
	@ApiOperation(httpMethod = "GET", value = "获取管辖分局树", notes = "获取管辖分局树")
	public ResponseModel<Object> creatTree() {
		return ResponseHelper.buildResponse(commonService.getTree());
	}


	/**
	 * 获取行政审批局树
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getApproveTree")
	@ApiOperation(httpMethod = "GET", value = "获取行政审批局树", notes = "获取行政审批局树")
	public ResponseModel<Object> getApproveTree() {
		return ResponseHelper.buildResponse(commonService.getApproveTree());
	}

	/**
	 * 通过单位类型获取单位列表
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getUnitList")
	@ApiOperation(httpMethod = "GET", value = "通过单位类型获取单位列表", notes = "通过单位类型获取单位列表")
	public ResponseModel<List<Map<String,Object>>> getUnitList(@RequestParam(value = "type") String type) {
		return ResponseHelper.buildResponse(commonService.getUnitListByType(type));
	}

	/**
	 * 查找当前公司下所属的安全管理员
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getSecurityAdmin")
	@ApiOperation(httpMethod = "GET", value = "查找当前公司下所属的安全管理员", notes = "查找当前公司下所属的安全管理员")
	public ResponseModel<List<Map<String, Object>>> getSecurityAdmin(@RequestParam(value = "type") String type,
																	@RequestParam(value = "useUnitCode",required = false)String useUnitCode) {
		return ResponseHelper.buildResponse(commonService.getSecurityAdmin(type,useUnitCode));
	}


	/**
	 * 查询安全管理员的基本信息
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getUserPhone")
	@ApiOperation(httpMethod = "GET", value = "查询用户对应联系方式", notes = "查询用户对应联系方式")
	public ResponseModel<Map<String,Object>> getUserInfo(@RequestParam(value = "sequenceNbr") String sequenceNbr) {
		return ResponseHelper.buildResponse(commonService.getUserInfo(sequenceNbr));
	}
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getUserInfoSplit")
    @ApiOperation(httpMethod = "GET", value = "查询安全管理员的基本信息", notes = "查询安全管理员的基本信息")
    public ResponseModel<Map<String, Object>> getUserInfoSplit(@RequestParam(value = "sequenceNbr") String sequenceNbr) {
        if (sequenceNbr.contains("_")) {
            sequenceNbr = sequenceNbr.split("_")[0];
        }
        return ResponseHelper.buildResponse(commonService.getUserInfo(sequenceNbr));
    }
	/**
	 * 查询企业的基本信息
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getEnterpriseInfo")
	@ApiOperation(httpMethod = "GET", value = "查询企业的基本信息", notes = "查询企业的基本信息")
	public ResponseModel<Map<String,Object>> getEnterpriseInfo(@RequestParam(value = "sequenceNbr") String sequenceNbr) {
		return ResponseHelper.buildResponse(commonService.getEnterpriseInfo(sequenceNbr));
	}

	/**
	 * 查询企业的下面的人员
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getEnterpriseEmployee")
	@ApiOperation(httpMethod = "GET", value = "查询企业的下面的人员", notes = "查询企业的下面的人员")
	public ResponseModel<List<Map<String,Object>>> getEnterpriseEmployee(@RequestParam String unitCode) {
		String companyCode = unitCode.split("_")[0];
		return ResponseHelper.buildResponse(commonService.getEnterpriseEmployee(companyCode));
	}

	@TycloudOperation (ApiLevel = UserType.AGENCY)
	@ApiOperation (httpMethod = "GET", value = "流程状态枚举列表", notes = "流程状态枚举列表")
	@GetMapping (value = "/flow-status/list")
	public ResponseModel<List<Map<String, Object>>> selectForFlowStatusList() {
		return ResponseHelper.buildResponse(Arrays.stream(FlowStatusEnum.values()).map(this::mapPointTypeToMap).filter(Objects::nonNull).collect(Collectors.toList()));
	}

	private Map<String, Object> mapPointTypeToMap(FlowStatusEnum e) {
		if (FlowStatusEnum.TO_SUBMITTED.getCode() ==  e.getCode() || FlowStatusEnum.TO_BE_DISCARD.getCode() == e.getCode()) {
			return null;
		}
		Map<String, Object> record = new HashMap<>();
		record.put("key", e.getCode());
		record.put("label", e.getName());
		return record;
	}
}
