package com.yeejoin.amos.boot.module.jg.biz.controller;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.jg.api.dto.JgScrapCancelDto;
import com.yeejoin.amos.boot.module.jg.api.enums.WorkFlowStatusEnum;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.util.*;

import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgChangeRegistrationNameServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.http.HttpServletRequest;

import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jg.api.dto.JgChangeRegistrationNameDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 更名变更登记
 *
 * @author system_generator
 * @date 2023-12-25
 */
@RestController
@Api(tags = "更名变更登记Api")
@RequestMapping(value = "/jg-change-registration-name")
public class JgChangeRegistrationNameController extends BaseController {

    @Autowired
    JgChangeRegistrationNameServiceImpl jgChangeRegistrationNameService;

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增/新增并提交", notes = "新增/新增并提交")
    public ResponseModel<Object> save(@RequestParam String submitType, @RequestBody Map<String, JSONObject> model) {
        jgChangeRegistrationNameService.save(submitType, model);
        return ResponseHelper.buildResponse("ok");
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param model 安装告知
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/updateInfo")
    @ApiOperation(httpMethod = "POST", value = "编辑API", notes = "编辑API")
    public ResponseModel<JgChangeRegistrationNameDto> updateInfo(@RequestParam String submitType,
                                                                 @RequestBody Map<String, Object> model,
                                                                 @RequestParam(value = "op", required = false) String op) {
        JgChangeRegistrationNameDto dto = BeanUtil.mapToBean(((LinkedHashMap) model.get("jgRegistrationInfo")), JgChangeRegistrationNameDto.class, true);
        if (Objects.isNull(dto)) {
            throw new IllegalArgumentException("参数jgRegistrationInfo不能为空");
        }
        Object o = ((LinkedHashMap<?, ?>) model.get("jgRegistrationInfo")).get("changeCertificateList");
        dto.setChangeCertificateList((List<Map<String, Object>>) o);
        return ResponseHelper.buildResponse(jgChangeRegistrationNameService.updateInfo(submitType, dto, op));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/deleteMessage")
    @ApiOperation(httpMethod = "POST", value = "单个删除", notes = "单个删除")
    public ResponseModel<Object> deleteMessage(@RequestParam("id") Long id) {
        List<Long> ids = Collections.singletonList(id);
        jgChangeRegistrationNameService.deleteBatch(ids);
        return ResponseHelper.buildResponse("ok");
    }

    /**
     * 撤回
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/withdraw")
    @ApiOperation(httpMethod = "POST", value = "撤回", notes = "撤回")
    public ResponseModel<Object> revocation(@RequestBody JSONObject map) {
        jgChangeRegistrationNameService.revocation(String.valueOf(map.get("instanceId")));
        return ResponseHelper.buildResponse("ok");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/flowExecute")
    @ApiOperation(httpMethod = "POST", value = "执行流程", notes = "执行流程")
    public ResponseModel<Object> flowExecute(@RequestBody JSONObject map) {

        LinkedHashMap model1 = (LinkedHashMap) map.get("model");
        LinkedHashMap jgRegistrationInfoMap = (LinkedHashMap) model1.get("jgRegistrationInfo");
        JgChangeRegistrationNameDto jgScrapCancelDto = JSON.parseObject(JSON.toJSONString(jgRegistrationInfoMap), JgChangeRegistrationNameDto.class);

        jgChangeRegistrationNameService.flowExecute(Long.valueOf(String.valueOf(jgScrapCancelDto.getSequenceNbr())), jgScrapCancelDto.getInstanceId(), String.valueOf(map.get("operate")), String.valueOf(map.get("opinion")));
        return ResponseHelper.buildResponse("ok");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "列表全部数据查询", notes = "列表全部数据查询")
    @PostMapping(value = "/getList")
    public ResponseModel<Page<Map<String, Object>>> getList(JgChangeRegistrationNameDto dto,
                                                            @RequestParam(value = "current") int current,
                                                            @RequestParam(value = "size") int size) {
        Page<Map<String, Object>> page = new Page<>(current, size);
        return ResponseHelper.buildResponse(jgChangeRegistrationNameService.getList(dto, page, dto.getRoleIds()));
    }


    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/details")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个详情", notes = "根据sequenceNbr查询单个详情")
    public ResponseModel<Map<String, Object>> selectOne(@RequestParam(required = false, value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(jgChangeRegistrationNameService.queryBySequenceNbr(sequenceNbr));
    }



    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "列表筛选办理状态下拉", notes = "列表筛选办理状态下拉")
    @GetMapping(value = "/getAuditStatusList")
    public ResponseModel<List<Map<String, String>>> getAuditStatusList(@RequestParam(value = "code") String code) {
        return ResponseHelper.buildResponse(WorkFlowStatusEnum.getInfoList(code));
    }


}
