package com.yeejoin.amos.boot.module.jg.biz.controller;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jg.api.dto.JgMaintenanceContractDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgMaintenanceContract;
import com.yeejoin.amos.boot.module.jg.api.vo.JgMaintenanceContractVo;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgMaintenanceContractServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.*;

/**
 * 维保合同备案
 *
 * @author system_generator
 * @date 2023-12-12
 */
@RestController
@Api(tags = "维保合同备案Api")
@RequestMapping(value = "/jg-maintenance-contract")
public class JgMaintenanceContractController extends BaseController {

    @Autowired
    JgMaintenanceContractServiceImpl jgMaintenanceContractServiceImpl;

    @Autowired
    RedisUtils redisUtils;

    /**
     * 新增(提交)
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/saveOrSubmit")
    @ApiOperation(httpMethod = "POST", value = "新增维保合同备案", notes = "新增维保合同备案")
    public ResponseModel<Object> save(@RequestBody Map<String,Object> model,
                                      @RequestParam(value = "submit") String submit) {
        ReginParams reginParams = getSelectedOrgInfo();
        return ResponseHelper.buildResponse(jgMaintenanceContractServiceImpl.saveOrSubmit(submit,model, reginParams));
    }

    /**
     * 更新维保合同和设备对应关系
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/updateMaintenanceAndEquipment")
    @ApiOperation(httpMethod = "POST", value = "更新维保合同和设备对应关系", notes = "更新维保合同和设备对应关系")
    public ResponseModel<Object> updateMaintenanceAndEquipment(@RequestBody Map<String , Object> model,
                                                               @RequestParam(value = "submit",required = false,defaultValue = "0") String submit) {
        JgMaintenanceContractDto dto = JSON.parseObject(JSON.toJSONString(model), JgMaintenanceContractDto.class);
        List<Map<String, Object>> list = (List<Map<String, Object>>) model.get("equipmentLists");
        return ResponseHelper.buildResponse(jgMaintenanceContractServiceImpl.updateMaintenanceAndEquipment(submit,dto,list));
    }

    /**
     * 提交
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/submit")
    @ApiOperation(httpMethod = "POST", value = "维保合同提交", notes = "维保合同提交")
    public ResponseModel<Object> submit(@RequestBody Map<String , Object> model) {
        JgMaintenanceContractDto dto = JSON.parseObject(JSON.toJSONString(model), JgMaintenanceContractDto.class);
        String comment = String.valueOf(model.get("comment"));
        String operate = String.valueOf(model.get("operate"));
        return ResponseHelper.buildResponse(jgMaintenanceContractServiceImpl.submit(dto,comment,operate));
    }

    /**
     * 审批
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/approval")
    @ApiOperation(httpMethod = "POST", value = "审批", notes = "审批")
    public ResponseModel<Object> approval(@RequestBody Map<String , Object> model) {
        JgMaintenanceContractDto dto = JSON.parseObject(JSON.toJSONString(model.get("formData")), JgMaintenanceContractDto.class);
        String comment = String.valueOf(model.get("comment"));
        String operate = String.valueOf(model.get("operate"));
        return ResponseHelper.buildResponse(jgMaintenanceContractServiceImpl.approval(dto,comment,operate));
    }


    /**
     * 撤回
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/revocation")
    @ApiOperation(httpMethod = "POST", value = "维保合同撤回", notes = "维保合同撤回")
    public ResponseModel<Object> revocation(@RequestBody JSONObject map) {
        jgMaintenanceContractServiceImpl.revocation(String.valueOf(map.get("instanceId")));
        return ResponseHelper.buildResponse("ok");
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/updateBySequenceNbr")
    @ApiOperation(httpMethod = "POST", value = "根据sequenceNbr更新维保合同备案", notes = "根据sequenceNbr更新维保合同备案")
    public ResponseModel<Object> updateBySequenceNbr(@RequestBody JgMaintenanceContractDto dto,
                                                                          @RequestParam("sequenceNbr") Long sequenceNbr) {
        dto.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(jgMaintenanceContractServiceImpl.updateBySequenceNbr(dto));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/delete")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除维保合同备案", notes = "根据sequenceNbr删除维保合同备案")
    public ResponseModel<Boolean> deleteBySequenceNbr(@RequestParam("sequenceNbr") Long sequenceNbr) {
        JgMaintenanceContractDto jgMaintenanceContractDto = new JgMaintenanceContractDto();
        jgMaintenanceContractDto.setSequenceNbr(sequenceNbr);
        jgMaintenanceContractDto.setIsDelete(true);
        return ResponseHelper.buildResponse(jgMaintenanceContractServiceImpl.updateBySequenceNbr(jgMaintenanceContractDto));
    }

    /**
     * 根据sequenceNbr批量删除
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "根据sequenceNbr删除维保合同备案", notes = "根据sequenceNbr删除维保合同备案")
    @RequestMapping(value = "/batchDelete", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public ResponseModel<Boolean> deleteForBatch(Long[] ids) {
        return ResponseHelper.buildResponse(jgMaintenanceContractServiceImpl.deleteForBatch(ids));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/details")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个维保合同备案", notes = "根据sequenceNbr查询单个维保合同备案")
    public ResponseModel<JgMaintenanceContractVo> selectOne(@RequestParam("sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(jgMaintenanceContractServiceImpl.queryBySequenceNbr(sequenceNbr));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/flowExecute")
    @ApiOperation(httpMethod = "POST", value = "执行流程", notes = "执行流程")
    public ResponseModel<Object> flowExecute(@RequestBody JSONObject map) {
        jgMaintenanceContractServiceImpl.flowExecute(Long.valueOf(String.valueOf(map.get("sequenceNbr"))),String.valueOf(map.get("instanceId")), String.valueOf(map.get("operate")), String.valueOf(map.get("comment")), true);
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        if (map.containsKey("formData") && !ObjectUtils.isEmpty(map.get("formData"))){
            JgMaintenanceContract dto = new JgMaintenanceContract();
            Map<String, Object> formData = (Map<String, Object>)map.get("formData");
            BeanUtil.copyProperties(formData, dto);
            JgMaintenanceContract result = new JgMaintenanceContract();
            if (!ObjectUtils.isEmpty(dto.getMaintenanceManagerOneId())) {
                result.setSequenceNbr(dto.getSequenceNbr());
                //维保人员一
                String[] maintenanceManagerOneInfo = dto.getMaintenanceManagerOneId().split("_");
                result.setMaintenanceManagerOneId(maintenanceManagerOneInfo[0]);
                result.setMaintenanceManagerOneName(maintenanceManagerOneInfo[1]);
                result.setMaintenanceManagerOnePhone(dto.getMaintenanceManagerOnePhone());

                //维保人员二
                String[] maintenanceManagerTwoInfo = dto.getMaintenanceManagerTwoId().split("_");
                result.setMaintenanceManagerTwoId(maintenanceManagerTwoInfo[0]);
                result.setMaintenanceManagerTwoName(maintenanceManagerTwoInfo[1]);
                result.setMaintenanceManagerTwoPhone(dto.getMaintenanceManagerTwoPhone());
                result.setPromoter(reginParams.getUserModel().getUserId());
            }
            jgMaintenanceContractServiceImpl.getBaseMapper().updateById(result);
        }

        return ResponseHelper.buildResponse("ok");
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "维保合同备案分页查询", notes = "分页查询维保合同备案")
    public ResponseModel<Page<JgMaintenanceContractVo>> queryForPage(@RequestParam(value = "current") int current,
                                                                      @RequestParam(value = "size") int size,
                                                                      @RequestParam(value = "phase") int phase,
                                                                      Map<String,Object> map,
                                                                      JgMaintenanceContractDto maintenanceContractDto) {
        Page<JgMaintenanceContract> page = new Page<>();
        page.setCurrent(current);
        page.setSize(size);
        ReginParams reginParams = getSelectedOrgInfo();
        Page<JgMaintenanceContractVo> contractDtoPage = jgMaintenanceContractServiceImpl.queryForPage(page, phase, map, reginParams);
        return ResponseHelper.buildResponse(contractDtoPage);
    }

}
