package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.aspose.words.SaveFormat;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.bo.CompanyBo;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jg.api.dto.ByteArrayMultipartFile;
import com.yeejoin.amos.boot.module.jg.api.mapper.CommonMapper;
import com.yeejoin.amos.boot.module.jg.biz.service.ICommonService;
import com.yeejoin.amos.boot.module.jg.biz.utils.FileExporter;
import com.yeejoin.amos.boot.module.jg.biz.utils.ImageUtils;
import com.yeejoin.amos.boot.module.jg.biz.utils.WordTemplateUtils;
import com.yeejoin.amos.boot.module.jg.flc.api.fegin.PrivilegeFeginService;
import com.yeejoin.amos.boot.module.ymt.api.entity.EquipmentCategory;
import com.yeejoin.amos.boot.module.ymt.api.mapper.EquipmentCategoryMapper;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Files;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 装备分类服务实现类
 *
 * @author system_generator
 * @date 2021-10-20
 */
@Service
@Slf4j
public class CommonServiceImpl implements ICommonService {

    @Autowired
    EquipmentCategoryMapper equipmentCategoryMapper;
    @Autowired
    private RedisUtils redisUtils;

    @Autowired
    CommonMapper commonMapper;

    //行政区划redis缓存key
    private static final String PROVINCE = "PROVINCE";
    private static final String CITY = "CITY";
    private static final String REGION = "REGION";
    private static final String STREET = "STREET";
    //行政区划level
    private static final String PROVINCE_LEVEL = "1";
    private static final String CITY_LEVEL = "2";
    private static final String REGION_LEVEL = "3";
    private static final String STREET_LEVEL = "4";

    //判断行政区划查询市还是区
    private static final String END_CODE = "0000";
    //判断行政区划查询街道
    private static final String STREET_END_CODE = "00";

    //管辖机构redis缓存key
    private static final String REGULATOR_UNIT_TREE = "REGULATOR_UNIT_TREE";

    //行政审批局redis缓存key
    private static final String ADMINISTRATION_UNIT_TREE = "ADMINISTRATION_UNIT_TREE";

    @Value("${regulator.unit.code}")
    private String code;

    @Autowired
    PrivilegeFeginService privilegeFeginService;

    public static byte[] file2byte(File file) {
        try {
            FileInputStream in = new FileInputStream(file);
            //当文件没有结束时，每次读取一个字节显示
            byte[] data = new byte[in.available()];
            in.read(data);
            in.close();
            return data;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<EquipmentCategory> getEquipmentCategoryList(String code, String type) {
        List<EquipmentCategory> result = new ArrayList<>();

        LambdaQueryWrapper<EquipmentCategory> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(EquipmentCategory::getCode, code);
        EquipmentCategory equipmentCategory = equipmentCategoryMapper.selectOne(wrapper);
        if (ObjectUtils.isEmpty(type)) {
            if(!ValidationUtil.isEmpty(equipmentCategory)){
                result.add(equipmentCategory);
            }
        } else {
            LambdaQueryWrapper<EquipmentCategory> wrapper2 = new LambdaQueryWrapper<>();
            wrapper2.eq(EquipmentCategory::getParentId, equipmentCategory.getId());
            List<EquipmentCategory> equipmentCategories = equipmentCategoryMapper.selectList(wrapper2);
            if(!ValidationUtil.isEmpty(equipmentCategories)){
                result = equipmentCategories;
            }
        }
        return result;
    }

    @Override
    public List<LinkedHashMap> getRegion(String level, String parentId) {
        List<LinkedHashMap> list = new ArrayList<>();
        if (!ObjectUtils.isEmpty(level)) {
            list = (List<LinkedHashMap>) redisUtils.get(PROVINCE);
            return ObjectUtils.isEmpty(list) ? getProvinceList(level) : list;
        } else if (!ObjectUtils.isEmpty(parentId)) {
            String regionCode = parentId.split("_")[0];
            //regionCode不是以00结尾查询街道，以0000结果查询市、否则查询区
            if (!regionCode.endsWith(STREET_END_CODE)) {
                list = ObjectUtils.isEmpty(redisUtils.get(STREET)) ? getProvinceList(STREET_LEVEL) : (List<LinkedHashMap>) redisUtils.get(STREET);
            } else if (regionCode.endsWith(END_CODE)) {
                list = ObjectUtils.isEmpty(redisUtils.get(CITY)) ? getProvinceList(CITY_LEVEL) : (List<LinkedHashMap>) redisUtils.get(CITY);
            } else {
                list = ObjectUtils.isEmpty(redisUtils.get(REGION)) ? getProvinceList(REGION_LEVEL) : (List<LinkedHashMap>) redisUtils.get(REGION);
            }
            return list.stream().filter(r -> regionCode.equals(r.get("parentRegionCode").toString())).collect(Collectors.toList());
        } else {
            return new ArrayList<>();
        }
    }


    public List<LinkedHashMap> getProvinceList(String level) {
        FeignClientResult result = privilegeFeginService.getProvince(level);
        List<LinkedHashMap> list = (List<LinkedHashMap>) result.getResult();
        for (LinkedHashMap linkedHashMap : list) {
            linkedHashMap.put("sequenceNbr", linkedHashMap.get("regionCode"));
        }
        switch (level) {
            case PROVINCE_LEVEL:
                redisUtils.set(PROVINCE, list);
                break;
            case CITY_LEVEL:
                redisUtils.set(CITY, list);
                break;
            case REGION_LEVEL:
                redisUtils.set(REGION, list);
                break;
            case STREET_LEVEL:
                redisUtils.set(STREET, list);
                break;
            default:
                log.error("不支持的行政区划：{}", level);
                break;
        }
        return list;
    }


    @Override
    public List<LinkedHashMap> getTree() {
        List<LinkedHashMap> result = (List<LinkedHashMap>) redisUtils.get(REGULATOR_UNIT_TREE);
        //判断redis是否存在管辖机构树
        return !ObjectUtils.isEmpty(result) ? result : creatTree();
    }

    @Override
    public List<LinkedHashMap> creatTree() {
        FeignClientResult tree = privilegeFeginService.queryAgencyTreeForCache(RequestContext.getToken(), RequestContext.getAppKey(), RequestContext.getProduct());
        List<LinkedHashMap> result = (List<LinkedHashMap>) tree.getResult();
        List<LinkedHashMap> treeData = deleteRegulatorTreeData(result);
        List<LinkedHashMap> supervisionTree = treeData.stream().filter(e -> code.equals(e.get("orgCode"))).collect(Collectors.toList());
        List<LinkedHashMap> resultTree = updateNullChildren(supervisionTree);
        redisUtils.set(REGULATOR_UNIT_TREE, resultTree);
        return resultTree;
    }

    @Override
    public List<LinkedHashMap> getApproveTree() {
        List<LinkedHashMap> result = (List<LinkedHashMap>) redisUtils.get(ADMINISTRATION_UNIT_TREE);
        //判断redis是否存在行政审批局树
        return !ObjectUtils.isEmpty(result) ? result : creatApproveTree();
    }


    @Override
    public List<LinkedHashMap> creatApproveTree() {
        FeignClientResult tree = privilegeFeginService.queryAgencyTreeForCache(RequestContext.getToken(), RequestContext.getAppKey(), RequestContext.getProduct());
        List<LinkedHashMap> result = (List<LinkedHashMap>) tree.getResult();
        List<LinkedHashMap> children = (List<LinkedHashMap>)result.get(0).get("children");
        List<LinkedHashMap> treeData = deleteTreeData(children);
        List<LinkedHashMap> resultTree = updateNullChildren(treeData);
        redisUtils.set(ADMINISTRATION_UNIT_TREE, resultTree);
        return resultTree;
    }

    private List<LinkedHashMap> deleteTreeData(List<LinkedHashMap> result) {
        Iterator it = result.iterator();
        while (it.hasNext()) {
            LinkedHashMap e = (LinkedHashMap) it.next();
            // 删除非行政审批局
            if (!e.get("companyType").toString().contains("行政审批局")) {
                it.remove();
            }
            if (!ObjectUtils.isEmpty(e.get("children"))) {
                deleteTreeData((List<LinkedHashMap>) e.get("children"));
            }
        }
        return result;
    }


    @Override
    public List<Map<String, Object>> getUnitListByType(String type) {

        if (type.equals("use")) {
            type = "使用单位";
        } else if (type.equals("maintenance")) {
            type = "安装改造维修单位";
        } else if (type.equals("inspection")) {
            type = "检验检测机构";
        }
        return commonMapper.getUnitListByType(type);
    }

    @Override
    public List<Map<String, Object>> getSecurityAdmin(String type, String companyCode) {
        if (ObjectUtils.isEmpty(companyCode)) {
            ReginParams reginParams = JSON.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
            CompanyBo company = reginParams.getCompany();
            companyCode = company.getCompanyCode();
        }
        String postName = null;
        if (type.equals("use")) {
            postName = "安全管理员";
        }
        if (type.equals("jyjc")) {
            postName = "检验检测人员";
        }
        if (type.equals("agw")) {
            postName = "安改维负责人";
        }
        if (type.equals("wbry")) {
            postName = "维保人员";
        }
        return ObjectUtils.isEmpty(postName) ? new ArrayList<>() : commonMapper.getSecurityAdmin(companyCode, postName);
    }

    @Override
    public Map<String, Object> getUserInfo(String sequenceNbr) {
        return commonMapper.getUserInfo(sequenceNbr.split("_")[0]);
    }

    @Override
    public Map<String, Object> getEnterpriseInfo(String sequenceNbr) {
        return commonMapper.getEnterpriseInfo(sequenceNbr);
    }

    @Override
    public List<Map<String,Object>> getEnterpriseEmployee(String unitCode) {
        return commonMapper.getEnterpriseEmployee(unitCode);
    }

    /**
     * 将管辖机构树中children为[]的修改为null
     *
     * @param result
     * @return
     */
    private List<LinkedHashMap> updateNullChildren(List<LinkedHashMap> result) {
        Iterator it = result.iterator();
        while (it.hasNext()) {
            LinkedHashMap e = (LinkedHashMap) it.next();
            //将管辖机构树中children为[]的修改为null
            if (e.get("children") != null) {
                if (((List<LinkedHashMap>) e.get("children")).size() == 0) {
                    e.put("children", null);
                }
            }
            if (!ObjectUtils.isEmpty(e.get("children"))) {
                updateNullChildren((List<LinkedHashMap>) e.get("children"));
            }
        }
        return result;
    }

    /**
     * 删除管辖机构树中level为使用单位的数据
     *
     * @param result 管辖机构树
     * @return 筛选过滤后不包含使用单位的管辖机构树
     */
    private List<LinkedHashMap> deleteRegulatorTreeData(List<LinkedHashMap> result) {
        Iterator it = result.iterator();
        while (it.hasNext()) {
            LinkedHashMap e = (LinkedHashMap) it.next();
            //删除使用单位
            if ("company".equals(e.get("level"))) {
                it.remove();
            }
            if (e.get("companyName").toString().contains("行政审批局")) {
                it.remove();
            }
            // 删除检验检测机构
            if (!"company".equals(e.get("level")) && e.get("companyType").toString().contains("检验检测机构")) {
                it.remove();
            }
            if (!ObjectUtils.isEmpty(e.get("children"))) {
                deleteRegulatorTreeData((List<LinkedHashMap>) e.get("children"));
            }
        }
        return result;
    }

    @Override
    public void generateCertificateReport(Map<String, Object> map, HttpServletResponse response) {
        if (CollectionUtils.isEmpty(map)) {
            throw new IllegalArgumentException("参数不能为空");
        }
        // 组装模板变量
        map.put("useRegistrationCode", Optional.ofNullable(map.get("useRegistrationCode")).orElse("").toString()); // 编号
        map.put("useUnitName", Optional.ofNullable(map.get("useUnitName")).orElse("").toString());  // 使用单位名称
        map.put("fullAddress", Optional.ofNullable(map.get("fullAddress")).orElse("").toString());  // 设备使用地点
        map.put("equList", Optional.ofNullable(map.get("equList")).orElse("").toString());  // 设备种类
        map.put("equipDefine", Optional.ofNullable(map.get("equipDefine")).orElse("").toString());  // 设备品种
        map.put("equipCode", Optional.ofNullable(map.get("equipCode")).orElse("").toString());  // 设备代码
        map.put("equipCategory", Optional.ofNullable(map.get("equipCategory")).orElse("").toString());  // 设备类别
        map.put("useInnerCode", Optional.ofNullable(map.get("useInnerCode")).orElse("").toString());  // 单位内编号
        map.put("factoryNum", Optional.ofNullable(map.get("factoryNum")).orElse("").toString());  // 产品编号
        map.put("receiveOrgName", Optional.ofNullable(map.get("receiveOrgName")).orElse("").toString());  // 登记机关
        map.put("giveOutYear", Optional.ofNullable(map.get("giveOutYear")).orElse("").toString());  // 发证日期-年
        map.put("giveOutMonth", Optional.ofNullable(map.get("giveOutMonth")).orElse("").toString());  // 发证日期-月
        map.put("giveOutDay", Optional.ofNullable(map.get("giveOutDay")).orElse("").toString());  // 发证日期-日
        // 生成二维码
        String qrCode = ImageUtils.generateQRCode(Optional.ofNullable(map.get("supervisoryCode")).orElse("").toString(), 100, 100);
        map.put("supervisoryCode", qrCode);  // 监管二维码

        // word转pdf
        File pdfFile;
        try {
            pdfFile = this.wordToPdf("equipment-registration-certificate-report.ftl", map);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }

//        // 上传pdf至文件服务器
//        String url = this.uploadFile(pdfFile);

        // 删除临时文件
//        try {
//            Files.deleteIfExists(pdfFile.toPath());
//        } catch (IOException e) {
//            log.error("删除临时文件失败：{}", e);
//        }

        try {
            byte[] bytes = file2byte(pdfFile);
            String docTitle = pdfFile.getName();
            FileExporter.exportFile(FileExporter.FileType.valueOf("pdf"), docTitle, bytes, response);
        } catch (Exception e) {
            log.error("pdf文件转换失败：{}", e);
        } finally {
            try {
                Files.deleteIfExists(pdfFile.toPath());
            } catch (Exception e) {
                log.error("文件找不到，删除失败：{}", e);
            }
        }
    }


    /**
     * word 转 pdf
     *
     * @param wordPath word文件路径
     */
    private File wordToPdf(String wordPath, Map<String, Object> placeholders) throws Exception {
        Assert.hasText(wordPath, "word文件路径不能为空");

        String tempFileName = "特种设备使用登记证_" + System.currentTimeMillis() + "_temp.pdf";

        WordTemplateUtils instance = WordTemplateUtils.getInstance();

        return instance.fillAndConvertDocFile(wordPath, tempFileName, placeholders, SaveFormat.PDF);
    }

    /**
     * 上传文件至文件服务器
     *
     * @param file 文件
     */
    private String uploadFile(File file) {
        Assert.notNull(file, "文件不能为空");

        MultipartFile multipartFile = new ByteArrayMultipartFile("file", "file.pdf", "application/pdf", file2byte(file));
        FeignClientResult<Map<String, String>> result = Systemctl.fileStorageClient.updateCommonFile(multipartFile);
        String urlString = "";
        if (result != null) {
            for (String s : result.getResult().keySet()) {
                urlString = s;
            }
        }
        return urlString;
    }
}