package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aspose.words.SaveFormat;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jg.api.dto.ByteArrayMultipartFile;
import com.yeejoin.amos.boot.module.jg.api.dto.JgTransferNoticeDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgTransferNotice;
import com.yeejoin.amos.boot.module.jg.api.entity.JgTransferNoticeEq;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgTransferNoticeEqMapper;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgTransferNoticeMapper;
import com.yeejoin.amos.boot.module.jg.api.service.IJgTransferNoticeService;
import com.yeejoin.amos.boot.module.jg.biz.feign.TzsServiceFeignClient;
import com.yeejoin.amos.boot.module.jg.biz.utils.ImageUtils;
import com.yeejoin.amos.boot.module.jg.biz.utils.WordTemplateUtils;
import com.yeejoin.amos.boot.module.ymt.api.entity.RegistrationInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.TzBaseUnitLicence;
import com.yeejoin.amos.boot.module.ymt.api.enums.ApplicationFormTypeEnum;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import com.yeejoin.amos.boot.module.ymt.api.mapper.*;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.workflow.Workflow;
import com.yeejoin.amos.feign.workflow.model.ActWorkflowBatchDTO;
import com.yeejoin.amos.feign.workflow.model.ActWorkflowStartDTO;
import com.yeejoin.amos.feign.workflow.model.AjaxResult;
import com.yeejoin.amos.feign.workflow.model.TaskResultDTO;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.text.ParseException;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 移装造告知服务实现类
 *
 * @author system_generator
 * @date 2023-12-19
 */
@Service
public class JgTransferNoticeServiceImpl extends BaseService<JgTransferNoticeDto,JgTransferNotice,JgTransferNoticeMapper> implements IJgTransferNoticeService {

    private static final String SUBMIT_TYPE_FLOW = "1";
    private static final String PROCESS_DEFINITION_KEY = "transferNotice";
    private static final String TABLE_PAGE_ID = "transferNoticeAdd";

    @Autowired
    EquipmentCategoryMapper equipmentCategoryMapper;
    @Autowired
    JgTransferNoticeEqMapper jgTransferNoticeEqMapper;
    @Autowired
    private JgTransferNoticeMapper jgTransferNoticeMapper;
    @Autowired
    RegistrationInfoMapper tzsJgRegistrationInfoMapper;
    @Autowired
    OtherInfoMapper tzsJgOtherInfoMapper;
    @Autowired
    TzsServiceFeignClient tzsServiceFeignClient;
    @Autowired
    SupervisoryCodeInfoMapper supervisoryCodeInfoMapper;
    @Autowired
    RedisUtils redisUtils;

    @Autowired
    private TzBaseUnitLicenceMapper baseUnitLicenceMapper;

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return 移装告知
     */
    @Override
    public Map<String, Map<String, Object>> queryBySequenceNbr(Long sequenceNbr) {
        // 移装告知信息
        JgTransferNotice notice = jgTransferNoticeMapper.selectById(sequenceNbr);
        if (Objects.isNull(notice)) {
            return null;
        }
        Map<String, Object> transferNotice = BeanUtil.beanToMap(notice);
        transferNotice.put("province", notice.getProvince() + "_" + notice.getProvinceName());
        transferNotice.put("city", notice.getCity() + "_" + notice.getCityName());
        transferNotice.put("county", notice.getCounty() + "_" + notice.getCountyName());
        transferNotice.put("useUnitCreditCode", notice.getUseUnitCreditCode() + "_" + notice.getUseUnitName());
        transferNotice.put("receiveOrgCode", notice.getReceiveOrgCode() + "_" + notice.getReceiveOrgName());
        if(!ValidationUtil.isEmpty(notice.getFactoryUseSiteStreet()) && !ValidationUtil.isEmpty(notice.getStreetName())) {
            transferNotice.put("factoryUseSiteStreet", notice.getFactoryUseSiteStreet() + "_" + notice.getStreetName());
        }
        if(!ValidationUtil.isEmpty(notice.getConstructionManagerId()) && !ValidationUtil.isEmpty(notice.getConstructionManager())) {
            transferNotice.put("constructionManagerId", notice.getConstructionManagerId() + "_" + notice.getConstructionManager());
        }
        String[] fields = {"productPhoto", "designDoc", "designStandard", "factoryStandard",
                "productQualityYieldProve", "insUseMaintainExplain", "inspectReport",
                "proxyStatementAttachment", "installContractAttachment", "powerOfAttorney", "constructionContract"};
        // 设备信息
        List<Map<String, Object>> equipmentInfos = jgTransferNoticeMapper.queryEquipInformation(sequenceNbr);

        for (String s : fields) {
            if (transferNotice.containsKey(s)) {
                if ("powerOfAttorney".equalsIgnoreCase(s)) {
                    transferNotice.put("powerOfAttorneyList", JSON.parseArray(transferNotice.get(s).toString()));
                } else if ("constructionContract".equalsIgnoreCase(s)) {
                    transferNotice.put("constructionContractList", JSON.parseArray(transferNotice.get(s).toString()));
                } else {
                    transferNotice.put(s, JSON.parseArray(transferNotice.get(s).toString()));
                }
            }
            if (equipmentInfos.get(0).containsKey(s)) {
                equipmentInfos.get(0).put(s, JSON.parseArray(equipmentInfos.get(0).get(s).toString()));
            }
        }
        return new HashMap<String, Map<String, Object>>() {{
            this.put("transferNoticeInfo", transferNotice);
            this.put("equipmentInfo", equipmentInfos.get(0));
        }};
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean deleteForBatch(Long[] sequenceNbrs) {
        if (Objects.isNull(sequenceNbrs) || sequenceNbrs.length == 0) {
            return false;
        }
        Collection<JgTransferNotice> jgTransferNotices = this.listByIds(Arrays.asList(sequenceNbrs));
        jgTransferNotices.forEach(notice -> {
            if (StringUtils.hasText(notice.getInspectionUnitCreditCode())) {
                throw new IllegalStateException("所选数据已存在流程，不能删除！");
            }
            notice.setIsDelete(true);
        });
        return this.updateBatchById(jgTransferNotices);
    }

    /**
     * 打印移装告知单
     *
     * @param sequenceNbr 主键
     * @return pdf文件路径
     */
    @Override
    public String generateTransferNoticeReport(Long sequenceNbr) {
        if (Objects.isNull(sequenceNbr)) {
            throw new IllegalArgumentException("参数不能为空");
        }

        JgTransferNotice jgTransferNotice = this.getById(sequenceNbr);
        List<Map<String, Object>> informationList = jgTransferNoticeMapper.queryEquipInformation(sequenceNbr);
        if (Objects.isNull(jgTransferNotice) || CollectionUtils.isEmpty(informationList)) {
            throw new IllegalArgumentException("移装告知单不存在");
        }
        Map<String, Object> maintain = informationList.get(0);

        String useCode = String.valueOf(maintain.get("installUnitCreditCode"));
        LambdaQueryWrapper<TzBaseUnitLicence> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(TzBaseUnitLicence::getUnitCode, useCode);
        List<TzBaseUnitLicence> list = baseUnitLicenceMapper.selectList(wrapper);

        ArrayList<String> installLicenseNoList = new ArrayList<>();
        ArrayList<String> installLicenseExpirationDateList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(list)) {
            list.forEach(tzBaseUnitLicence -> {
                // 因模板许可证编号配置最多支持三个，再多样式混乱，目前返回三个
                if (installLicenseNoList.size() < 3) {
                    installLicenseNoList.add(tzBaseUnitLicence.getCertNo());
                    installLicenseExpirationDateList.add(DateUtils.convertDateToString(tzBaseUnitLicence.getExpiryDate(), DateUtils.DATE_PATTERN));
                }
            });
        }

        Function<String, String> getValue = key -> maintain.getOrDefault(key, "").toString();

        // 组装模板变量
        Map<String, Object> placeholders = new HashMap<>();
        placeholders.put("sequenceNbr", getValue.apply("sequenceNbr"));
        placeholders.put("installUnitName", getValue.apply("installUnitName"));
        placeholders.put("applyNo", getValue.apply("applyNo"));
        placeholders.put("productName", getValue.apply("productName"));
        placeholders.put("equipType", getValue.apply("equType"));
        placeholders.put("equipCode", getValue.apply("equRegisterCode"));
        placeholders.put("produceCode", getValue.apply("factoryNum")); // TODO: 制造编号 - 设备出厂编号
        placeholders.put("produceUnitName", getValue.apply("produceUnitName"));
        placeholders.put("produceLicenseNum", getValue.apply("produceLicenseNum"));
        placeholders.put("fullAddress", getValue.apply("provinceName") + getValue.apply("cityName") + getValue.apply("countyName") + getValue.apply("address"));
        placeholders.put("installStartDate", getValue.apply("installStartDate"));
        placeholders.put("installType", "移装"); // TODO: 施工类别
        placeholders.put("installLicenseNo", "");
        placeholders.put("installLicenseExpirationDate", "");
        placeholders.put("installLeaderName", getValue.apply("installLeaderName"));// 施工负责人
        placeholders.put("installLeaderPhone", getValue.apply("installLeaderPhone"));// 施工负责人手机
        placeholders.put("installUnitAddress", getValue.apply("provinceName") + getValue.apply("cityName") + getValue.apply("countyName") + getValue.apply("streetName") + getValue.apply("address")); // TODO: 施工单位地址
        placeholders.put("useUnitName", getValue.apply("useUnitName"));
        placeholders.put("useUnitLeaderName", getValue.apply("safetyManager"));
        placeholders.put("useUnitLeaderPhone", getValue.apply("safetyManagerPhone"));
        placeholders.put("useUnitLeaderAddress", getValue.apply("useUnitProvinceName") + getValue.apply("useUnitCityName") + getValue.apply("useUnitCountyName") + getValue.apply("useUnitAddress"));
        // 生成二维码
        String qrCode = ImageUtils.generateQRCode(getValue.apply("applyNo"), 300, 300);
        placeholders.put("qrCode", qrCode);

        placeholders.put("installLicenseNoList", installLicenseNoList);
        placeholders.put("installLicenseExpirationDateList", installLicenseExpirationDateList);
        String tempFileName = "安装告知单_" + System.currentTimeMillis() + "_temp";
        String url = WordTemplateUtils.templateToPdf(tempFileName, "installation-notification-report.ftl", placeholders);

        // 更新到数据库
        jgTransferNotice.setNoticeReportUrl(url);
        this.updateById(jgTransferNotice);

        return url;
    }


    /**
     * 更新移装告知
     *
     * @param noticeDto 移装告知
     */
    @SuppressWarnings({"rawtypes", "Duplicates"})
    public JgTransferNoticeDto updateTransferNotice(String submitType, JgTransferNoticeDto noticeDto, String op) {
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        if (Objects.isNull(noticeDto) || StringUtils.isEmpty(submitType)) {
            throw new IllegalArgumentException("参数不能为空");
        }
        String[] taskName = new String[]{"流程结束"};
        // 字段转换
        this.convertField(noticeDto);
        ArrayList<String> roleListFirst = new ArrayList<>();
        ArrayList<String> roleListSecond = new ArrayList<>();
        noticeDto.setPromoter(reginParams.getUserModel().getUserId());
        if (SUBMIT_TYPE_FLOW.equals(submitType)) {
            AjaxResult ajaxResult;
            // 发起流程
            if (!StringUtils.hasText(noticeDto.getInstanceId())) {
                ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
                dto.setProcessDefinitionKey(PROCESS_DEFINITION_KEY);
                dto.setBusinessKey("1");
                try {
                    ajaxResult = Workflow.taskClient.startByVariable(dto);
                    String instanceId = ((Map) ajaxResult.get("data")).get("id").toString();
                    noticeDto.setInstanceId(instanceId);
                    // 查询下节点任务
                    getNext(roleListFirst, instanceId,taskName);
                    noticeDto.setInstanceStatus(String.join(",", roleListFirst));
                } catch (Exception e) {
                    log.error("提交失败：{}", e);
                }
            }

            JgTransferNotice notice = new JgTransferNotice();
            BeanUtils.copyProperties(noticeDto,notice);

            boolean submit = submit(notice, op);

            if(submit) {
                // 查询下节点任务
                getNext(roleListSecond, notice.getInstanceId(),taskName);
                notice.setStatus(taskName[0]);
                if (!ObjectUtils.isEmpty(notice.getInstanceStatus())) {
                    notice.setInstanceStatus(notice.getInstanceStatus() + "," + roleListSecond);
                } else {
                    notice.setInstanceStatus(String.join(",", roleListSecond));
                }
                notice.setPromoter(RequestContext.getExeUserId());
                notice.setNextExecuteIds(String.join(",", roleListSecond));
                notice.setNoticeStatus(String.valueOf(FlowStatusEnum.TO_BE_PROCESSED.getCode()));
                jgTransferNoticeMapper.updateById(notice);
            }
        } else {
            JgTransferNotice bean = new JgTransferNotice();
            BeanUtils.copyProperties(noticeDto, bean);
            jgTransferNoticeMapper.updateById(bean);
        }
        return noticeDto;
    }

    /**
     * 分页查询
     */
    public Page<JgTransferNoticeDto> queryForJgTransferNoticePage(Page<JgTransferNotice> page, JgTransferNoticeDto model, String type, ReginParams reginParams)   {
        String orgCode;
        orgCode = reginParams.getCompany().getCompanyCode();
        model.setReceiveOrgCode(orgCode);
        Page<JgTransferNotice> noticePage = jgTransferNoticeMapper.queryForPage(page, model, type, orgCode);

        // 将Page<JgTransferNotice>转化为Page<JgTransferNoticeDto>
        Page<JgTransferNoticeDto> noticeDtoPage = new Page<>();
        BeanUtils.copyProperties(noticePage, noticeDtoPage, "records");
        List<JgTransferNoticeDto> records = noticePage.getRecords().stream().map(notice -> {
            JgTransferNoticeDto noticeDto = new JgTransferNoticeDto();
            BeanUtils.copyProperties(notice, noticeDto);
            if (Objects.nonNull(notice.getNoticeStatus())) {
                String noticeStatusDesc = FlowStatusEnum.getNameByType(Long.valueOf(notice.getNoticeStatus()));
                noticeDto.setNoticeStatusDesc(noticeStatusDesc);
            }
            return noticeDto;
        }).collect(java.util.stream.Collectors.toList());
        noticeDtoPage.setRecords(records);

        return noticeDtoPage;
    }

    /**
     * 列表查询 示例
     */
    public List<JgTransferNoticeDto> queryForJgTransferNoticeList()   {
        return this.queryForList("" , false);
    }

    @Override
    @SuppressWarnings({"Duplicates", "rawtypes"})
    @Transactional(rollbackFor = Exception.class)
    public void saveNotice(String submitType, Map<String, JgTransferNoticeDto> jgTransferNoticeDtoMap, ReginParams reginParams) {
        String[] taskName = new String[]{"流程结束"};
        JgTransferNoticeDto model = jgTransferNoticeDtoMap.get(TABLE_PAGE_ID);
        // 字段转换
        convertField(model);

        // 获取告知设备列表
        List<Map<String, Object>> deviceList = model.getDeviceList();
        if (CollectionUtils.isEmpty(deviceList)) {
            return;
        }

        // 获取告知单号
        ResponseModel<List<String>> responseModel = tzsServiceFeignClient.applicationFormCode(ApplicationFormTypeEnum.YZGZ.getCode(), deviceList.size());
        if (CollectionUtils.isEmpty(responseModel.getResult())) {
            return;
        }

        ArrayList<String> roleListFirst = new ArrayList<>();
        ArrayList<String> roleListSecond = new ArrayList<>();
        // 判断当前是否为提交
        List<String> instanceIdList = new ArrayList<>();
        if (SUBMIT_TYPE_FLOW.equals(submitType)) {
            // 发起流程
            // ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
            ActWorkflowBatchDTO actWorkflowBatchDTO = new ActWorkflowBatchDTO();
            List<ActWorkflowStartDTO> list = new ArrayList<>();
            for (int i = 0; i < deviceList.size(); i++
            ) {
                ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
                dto.setProcessDefinitionKey(PROCESS_DEFINITION_KEY);
                dto.setBusinessKey(String.valueOf(i));
//                dto.setCompleteFirstTask(true);
                list.add(dto);
            }
            actWorkflowBatchDTO.setProcess(list);

            try {
                FeignClientResult result = Workflow.taskV2Client.startByVariableBatch(actWorkflowBatchDTO);
                List<Object> returnList = (List<Object>) result.getResult();
                for (Object obj : returnList
                ) {
                    JSONObject jsonObject = JSON.parseObject(JSONObject.toJSONString(obj));
                    String instanceId = jsonObject.getString("id");
                    instanceIdList.add(instanceId);
                    // 查询下节点任务
                    if(returnList.get(0).equals(obj)) {
                        getNext(roleListFirst, instanceId,taskName);
                    }
                    // 推动下一个节点
                    AjaxResult ajaxResult = Workflow.taskClient.getTask(instanceId);
                    JSONObject dataObject = JSON.parseObject(JSON.toJSONString(ajaxResult.get("data")));
                    String taskId = dataObject.getString("id");
                    //组装信息
                    TaskResultDTO dto = new TaskResultDTO();
                    dto.setResultCode("approvalStatus");
                    dto.setTaskId(taskId);
                    dto.setComment("提交流程");
                    HashMap<String, Object> map = new HashMap<>();
                    map.put("approvalStatus", "0");
                    dto.setVariable(map);
                    //执行流程
                    AjaxResult ajaxResult1 = null;
                    try {
                        ajaxResult1 = Workflow.taskClient.completeByTask(taskId, dto);
                        if (ajaxResult1.get("code").equals(200)) {
                            getNext(roleListSecond, instanceId,taskName);
                        } else {
                            log.error("提交失败");
                        }
                    } catch (Exception e) {
                        log.error("提交失败：{}", e);
                    }
                }
            } catch (Exception e) {
                log.error("提交失败：{}", e);
            }
        }

        List<JgTransferNotice> list = new ArrayList<>();
        List<JgTransferNoticeEq> equipList = new ArrayList<>();
        deviceList.forEach(obj -> {
            JgTransferNoticeEq jgRelationEquip = new JgTransferNoticeEq();
            JgTransferNotice dto = new JgTransferNotice();
            BeanUtils.copyProperties(model, dto);
            int i = deviceList.indexOf(obj);
            String applyNo = responseModel.getResult().get(i);
            dto.setPromoter(reginParams.getUserModel().getUserId());
            dto.setApplyNo(applyNo);
            dto.setNoticeDate(new Date());
            if(SUBMIT_TYPE_FLOW.equals(submitType)) {
                dto.setNextExecuteIds(String.join(",", roleListSecond));
                dto.setInstanceStatus(String.join(",", roleListFirst));
                dto.setPromoter(reginParams.getUserModel().getUserId());
                dto.setStatus(taskName[0]);
            }
            dto.setInstallUnitName(reginParams.getCompany().getCompanyName());
            dto.setInstallUnitCreditCode(reginParams.getCompany().getCompanyCode());
            jgRelationEquip.setEquId(String.valueOf(obj.get("SEQUENCE_NBR")));
            jgRelationEquip.setEquipTransferId(applyNo);
            if (!CollectionUtils.isEmpty(instanceIdList)) {
                dto.setInstanceId(instanceIdList.get(i));
                dto.setNoticeStatus(String.valueOf(FlowStatusEnum.TO_BE_PROCESSED.getCode()));
            } else {
                dto.setNoticeStatus(String.valueOf(FlowStatusEnum.TO_BE_SUBMITTED.getCode()));
            }
            list.add(dto);
            equipList.add(jgRelationEquip);
        });

        jgTransferNoticeMapper.insertBatchSomeColumn(list);

        List<JgTransferNoticeEq> jgRelationEquipList = equipList.stream().map(jgRelationEquip -> {
            List<JgTransferNotice> collect = list.stream().filter(JgTransferNotice -> jgRelationEquip.getEquipTransferId().equals(JgTransferNotice.getApplyNo())).collect(Collectors.toList());
            Long sequenceNbr = collect.get(0).getSequenceNbr();
            return jgRelationEquip.setEquipTransferId(String.valueOf(sequenceNbr));
        }).collect(Collectors.toList());

        jgTransferNoticeEqMapper.insertBatchSomeColumn(jgRelationEquipList);
    }

    private void convertField(JgTransferNoticeDto model) {
        // 处理图片
        if(!ValidationUtil.isEmpty(model.getConstructionContractList())) {
            model.setConstructionContract(JSON.toJSONString(model.getConstructionContractList()));
        }
        if(!ValidationUtil.isEmpty(model.getPowerOfAttorneyList())) {
            model.setPowerOfAttorney(JSON.toJSONString(model.getPowerOfAttorneyList()));
        }

        // 分割省市区字段
        String province = model.getProvince();
        if (!ObjectUtils.isEmpty(province)) {
            String[] provinceList = province.split("_");
            if (provinceList.length > 1) {
                model.setProvince(provinceList[0]);
                model.setProvinceName(provinceList[1]);
            }
        }

        String city = model.getCity();
        if (!ObjectUtils.isEmpty(city)) {
            String[] cityList = city.split("_");
            if (cityList.length > 1) {
                model.setCity(cityList[0]);
                model.setCityName(cityList[1]);
            }
        }

        String county = model.getCounty();
        if (!ObjectUtils.isEmpty(county)) {
            String[] countyList = county.split("_");
            if (countyList.length > 1) {
                model.setCounty(countyList[0]);
                model.setCountyName(countyList[1]);
            }
        }

        // 分割单位
        String useUnitId = model.getUseUnitCreditCode();
        if (!ObjectUtils.isEmpty(useUnitId)) {
            String[] useUnitList = useUnitId.split("_");
            if (useUnitList.length > 1) {
                model.setUseUnitCreditCode(useUnitList[0]);
                model.setUseUnitName(useUnitList[1]);
            }
        }

        String receiveOrgId = model.getReceiveOrgCode();
        if (!ObjectUtils.isEmpty(receiveOrgId)) {
            String[] receiveOrgIdList = receiveOrgId.split("_");
            if (receiveOrgIdList.length > 1) {
                model.setReceiveOrgCode(receiveOrgIdList[0]);
                model.setReceiveOrgName(receiveOrgIdList[1]);
            }
        }

        String constructionManagerId = model.getConstructionManagerId();
        if (!ObjectUtils.isEmpty(constructionManagerId)) {
            String[] constructionManagerIdList = constructionManagerId.split("_");
            if (constructionManagerIdList.length > 1) {
                model.setConstructionManagerId(constructionManagerIdList[0]);
                model.setConstructionManager(constructionManagerIdList[1]);
            }
        }

        String factoryUseSiteStreet = model.getFactoryUseSiteStreet();
        if (!ObjectUtils.isEmpty(factoryUseSiteStreet)) {
            String[] factoryUseSiteStreetList = factoryUseSiteStreet.split("_");
            if (factoryUseSiteStreetList.length > 1) {
                model.setFactoryUseSiteStreet(factoryUseSiteStreetList[0]);
                model.setStreetName(factoryUseSiteStreetList[1]);
            }
        }
    }

    private String convertImageUrl(List<Map<String, String>> urlList) {
        String urls = "";
        if (!CollectionUtils.isEmpty(urlList)) {
            urls = urlList.stream().map(map -> map.get("url")).collect(Collectors.joining(","));
        }
        return urls;
    }

    public boolean submit(JgTransferNotice notice, String op) {

        AjaxResult ajaxResult = Workflow.taskClient.getTask(notice.getInstanceId());
        JSONObject dataObject = JSON.parseObject(JSON.toJSONString(ajaxResult.get("data")));
        String taskId = dataObject.getString("id");
        //组装信息
        TaskResultDTO dto = new TaskResultDTO();
        dto.setResultCode("approvalStatus");
        dto.setTaskId(taskId);
        dto.setComment("提交流程");
        HashMap<String, Object> map = new HashMap<>();
        if(notice.getNoticeStatus().equals("6614") || notice.getNoticeStatus().equals("6615") ) {
            map.put("approvalStatus", "提交");
        } else {
            map.put("approvalStatus", op);
        }

        dto.setVariable(map);
        //执行流程
        AjaxResult ajaxResult1 = null;
        try {
            ajaxResult1 = Workflow.taskClient.completeByTask(taskId, dto);
            if (ajaxResult1.get("code").equals(200)) {
                return true;
            } else {
                return false;
            }
        } catch (Exception e) {
            log.error("提交失败：{}", e);
            return false;
        }
    }

    public void cancel(JgTransferNoticeDto noticeDto) {
        String[] taskName = new String[]{"流程结束"};
        FeignClientResult ajaxResult = Workflow.taskV2Client.rollBack(noticeDto.getInstanceId());
        JgTransferNotice jgInstallationNotice = this.baseMapper.selectById(noticeDto.getSequenceNbr());
        ArrayList<String> roleList = new ArrayList<>();
        if(ajaxResult.getStatus() == 200) {
            getNext(roleList, noticeDto.getInstanceId(),taskName);
            jgInstallationNotice.setStatus(taskName[0]);
            jgInstallationNotice.setPromoter("");
            jgInstallationNotice.setNextExecuteIds(String.join(",", roleList));
            jgInstallationNotice.setNoticeStatus(String.valueOf(FlowStatusEnum.ROLLBACK.getCode()));
            jgTransferNoticeMapper.updateById(jgInstallationNotice);
        }
    }

    @Transactional
    public void accept(JgTransferNoticeDto dto, String op) {
        String[] taskName = new String[]{"流程结束"};
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        JgTransferNotice jgTransferNotice = this.jgTransferNoticeMapper.selectById(dto.getSequenceNbr());
        // 组装设备注册代码
        StringBuffer stringBuffer = new StringBuffer();
        String ym = null;
        try {
            ym = DateUtils.dateFormat(new Date(), DateUtils.DATE_PATTERN_MM);
        } catch (ParseException e) {
            log.error("日期转换失败：{}", e);
        }

        ArrayList<String> roleList = new ArrayList<>();
        boolean submit = submit(jgTransferNotice, op);
        if(submit) {
            getNext(roleList, dto.getInstanceId(), taskName);
            jgTransferNotice.setPromoter(reginParams.getUserModel().getUserId());
            if("0".equals(op)) {
                if (roleList.size() == 0) {
                    LambdaQueryWrapper<JgTransferNoticeEq> queryWrapper = new LambdaQueryWrapper<>();
                    queryWrapper.eq(JgTransferNoticeEq::getEquipTransferId, dto.getSequenceNbr());
                    JgTransferNoticeEq jgTransferNoticeEq = jgTransferNoticeEqMapper.selectOne(queryWrapper);
                    LambdaQueryWrapper<RegistrationInfo> queryWrapper2 = new LambdaQueryWrapper<>();
                    queryWrapper2.eq(RegistrationInfo::getRecord, jgTransferNoticeEq.getEquId());
                    RegistrationInfo tzsJgRegistrationInfo = tzsJgRegistrationInfoMapper.selectOne(queryWrapper2);
                    stringBuffer.append(tzsJgRegistrationInfo.getEquCategory()).append(jgTransferNotice.getCity()).append(ym);
                    Map<String, Object> map = new HashMap<>();
                    map.put("cityCode", jgTransferNotice.getCity());
                    map.put("countyCode", jgTransferNotice.getCounty());
                    map.put("equCategory", tzsJgRegistrationInfo.getEquCategory());
                    jgTransferNotice.setPromoter("");
                    jgTransferNotice.setHandleDate(new Date());
                    jgTransferNotice.setNoticeStatus(String.valueOf(FlowStatusEnum.TO_BE_FINISHED.getCode()));
                    this.generateTransferNoticeReport(jgTransferNotice.getSequenceNbr());
                } else {
                    jgTransferNotice.setNextExecuteIds(String.join(",", roleList));
                    if (!ObjectUtils.isEmpty(jgTransferNotice.getInstanceStatus())) {
                        jgTransferNotice.setInstanceStatus(jgTransferNotice.getInstanceStatus() + "," + String.join(",", roleList));
                    } else {
                        jgTransferNotice.setInstanceStatus(String.join(",", roleList));
                    }
                    jgTransferNotice.setNoticeStatus(String.valueOf(FlowStatusEnum.TO_BE_SUBMITTED.getCode()));
                    jgTransferNotice.setInstanceStatus(String.valueOf(FlowStatusEnum.REJECTED.getCode()));
                }
            } else {
                jgTransferNotice.setPromoter("");
                jgTransferNotice.setNoticeStatus(String.valueOf(FlowStatusEnum.REJECTED.getCode()));
            }
            jgTransferNoticeMapper.updateById(jgTransferNotice);
        }
    }

    void getNext(ArrayList<String> roleListFirst, String instanceId, String[] taskName) {
        AjaxResult aj = Workflow.taskClient.getTaskNoAuth(instanceId);
        JSONObject taskNoAuth = JSON.parseObject(JSON.toJSONString(aj.get("data")));
        if (!ObjectUtils.isEmpty(taskNoAuth)) {
            String nextTaskId = taskNoAuth.getString("id");
            AjaxResult taskGroupName = Workflow.taskClient.getTaskGroupName(nextTaskId);
            taskName[0] = taskNoAuth.getString("name");
            JSONArray data = JSON.parseArray(JSON.toJSONString(taskGroupName.get("data")));
            for (Object datum : data) {
                if (((Map) datum).containsKey("groupId")) {
                    roleListFirst.add(((Map) datum).get("groupId").toString());
                }
            }
        }
    }
}