package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jg.api.dto.JgUseRegistrationDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgRegistrationHistory;
import com.yeejoin.amos.boot.module.jg.api.entity.JgUseRegistration;
import com.yeejoin.amos.boot.module.jg.api.entity.JgUseRegistrationEq;
import com.yeejoin.amos.boot.module.jg.api.enums.EquipTypeEnum;
import com.yeejoin.amos.boot.module.jg.api.enums.WorkFlowStatusEnum;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgUseRegistrationEqMapper;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgUseRegistrationMapper;
import com.yeejoin.amos.boot.module.jg.api.service.IJgUseRegistrationService;
import com.yeejoin.amos.boot.module.jg.biz.feign.TzsServiceFeignClient;
import com.yeejoin.amos.boot.module.jg.flc.api.fegin.WorkFlowFeignService;
import com.yeejoin.amos.boot.module.ymt.api.entity.InspectionDetectionInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.OtherInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.UseInfo;
import com.yeejoin.amos.boot.module.ymt.api.enums.ApplicationFormTypeEnum;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import com.yeejoin.amos.boot.module.ymt.api.mapper.IdxBizJgRegisterInfoMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.InspectionDetectionInfoMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.OtherInfoMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.UseInfoMapper;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.workflow.Workflow;
import com.yeejoin.amos.feign.workflow.model.ActWorkflowStartDTO;
import com.yeejoin.amos.feign.workflow.model.AjaxResult;
import com.yeejoin.amos.feign.workflow.model.TaskResultDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.*;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2023-12-12
 */
@Service
public class JgUseRegistrationServiceImpl extends BaseService<JgUseRegistrationDto, JgUseRegistration, JgUseRegistrationMapper> implements IJgUseRegistrationService {

    @Autowired
    private UseInfoMapper useInfoMapper;
    @Autowired
    private InspectionDetectionInfoMapper inspectionDetectionInfoMapper;
    @Autowired
    private OtherInfoMapper otherInfoMapper;
    @Autowired
    private JgUseRegistrationEqMapper jgRelationEquipMapper;
    @Autowired
    WorkFlowFeignService workFlowFeginService;
    @Autowired
    RedisUtils redisUtils;
    @Autowired
    TzsServiceFeignClient tzsServiceFeignClient;
    @Autowired
    JgRegistrationHistoryServiceImpl jgRegistrationHistoryService;
    @Autowired
    IdxBizJgRegisterInfoMapper idxBizJgRegisterInfoMapper;
    public Page<Map<String, Object>> getList(JgUseRegistrationDto dto, Page<Map<String, Object>> page, List<String> roleIds) {
        Page<Map<String, Object>> listPage = this.baseMapper.getListPage(page, dto, roleIds);
        return listPage;
    }

    public Page<Map<String, Object>> getEquipList(Page<Map<String, Object>> page, String factoryNum, String equList, String equCategory) {
        return this.baseMapper.getEquipListPage(page, factoryNum, equList, equCategory);
    }

    public void updateEquipMessage(String currentDocumentId, String useOrgCode){
        LambdaQueryWrapper<JgRegistrationHistory> lambdaSelect = new QueryWrapper<JgRegistrationHistory>().lambda();
        lambdaSelect.eq(JgRegistrationHistory::getCurrentDocumentId, currentDocumentId);
        JgRegistrationHistory jgRegistrationHistory = jgRegistrationHistoryService.getBaseMapper().selectOne(lambdaSelect);
        JSONObject map = JSONObject.parseObject(jgRegistrationHistory.getChangeData());
        UseInfo useInfo = new UseInfo();
        BeanUtil.copyProperties(map, useInfo);
        LambdaQueryWrapper<UseInfo> lambda = new QueryWrapper<UseInfo>().lambda();
        lambda.eq(UseInfo::getRecord, map.get("equipId"));
        // 更新使用信息
        useInfoMapper.update(useInfo, lambda);
        InspectionDetectionInfo inspectionDetectionInfo = new InspectionDetectionInfo();
        BeanUtil.copyProperties(map, inspectionDetectionInfo);
        LambdaQueryWrapper<InspectionDetectionInfo> inspectionLambda = new QueryWrapper<InspectionDetectionInfo>().lambda();
        inspectionLambda.eq(InspectionDetectionInfo::getRecord, map.get("equipId"));
        // 更新检验检测信息
        inspectionDetectionInfo.setInspectReport(null);
        inspectionDetectionInfoMapper.update(inspectionDetectionInfo, inspectionLambda);
        // 更新设备使用登记证
        idxBizJgRegisterInfoMapper.updateUseOrgCodeByEquip(String.valueOf(map.get("equipId")), useOrgCode);
    }

    public void updateHistory(JSONObject map, String equipId, String currentDocumentId, String supervisoryCode){
        JgRegistrationHistory jgRegistrationHistory = new JgRegistrationHistory();
        LambdaQueryWrapper<JgRegistrationHistory> lambda = new QueryWrapper<JgRegistrationHistory>().lambda();
        lambda.eq(JgRegistrationHistory::getEquId, equipId);
        lambda.eq(JgRegistrationHistory::getCurrentDocumentId, currentDocumentId);
        lambda.eq(JgRegistrationHistory::getRegistrationClass, "使用登记");
        Integer integer = jgRegistrationHistoryService.getBaseMapper().selectCount(lambda);
        if (integer > 0){
            jgRegistrationHistory.setChangeData(JSON.toJSONString(map));
            jgRegistrationHistoryService.update(jgRegistrationHistory, lambda);
        }else {
            jgRegistrationHistory.setChangeData(JSON.toJSONString(map));
            jgRegistrationHistory.setStatus("new");
            jgRegistrationHistory.setRegistrationClass("使用登记");
            jgRegistrationHistory.setSupervisoryCode(supervisoryCode);
            jgRegistrationHistory.setEquId(equipId);
            jgRegistrationHistory.setCurrentDocumentId(currentDocumentId);
            jgRegistrationHistoryService.save(jgRegistrationHistory);
        }

    }

    @Transactional
    public void save(JSONObject map) {
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        // 使用登记信息
        JgUseRegistration jgUseRegistration = new JgUseRegistration();
        jgUseRegistration.setRegDate(new Date());
        LambdaQueryWrapper<OtherInfo> otherLambda = new QueryWrapper<OtherInfo>().lambda();
        otherLambda.eq(OtherInfo::getRecord, map.get("equipId"));
        OtherInfo otherInfo = otherInfoMapper.selectOne(otherLambda);
        String supervisoryCode = otherInfo.getSupervisoryCode();
        jgUseRegistration.setSupervisoryCode(supervisoryCode);
        jgUseRegistration.setUseUnitName(String.valueOf(map.get("useUnitName")));
        jgUseRegistration.setUseUnitCreditCode(String.valueOf(map.get("useUnitCreditCode")));
        if (map.containsKey("receiveOrgCode")) {
            //维保单位信息
            String[] splitMaintenanceUnitCode = String.valueOf(map.getString("receiveOrgCode")).split("_");
            jgUseRegistration.setReceiveCompanyCode(splitMaintenanceUnitCode[0]);
            jgUseRegistration.setReceiveOrgName(splitMaintenanceUnitCode[1]);

        } else {
            jgUseRegistration.setReceiveCompanyCode("610000");
        }
        // 使用单位提交
        jgUseRegistration.setUseUnitCreditCode(reginParams.getCompany().getCompanyCode());
        jgUseRegistration.setCreateUserId(reginParams.getUserModel().getUserId());
        if (!ObjectUtils.isEmpty(map.get("inspectUnitCreditCode"))) {
            jgUseRegistration.setInspectUnitCreditCode(map.get("inspectUnitCreditCode").toString());
        }
        if (!ObjectUtils.isEmpty(map.get("inspectOrgName"))) {
            jgUseRegistration.setInspectUnitName(map.get("inspectOrgName").toString());
        }


        if (map.containsKey("type") && "edit".equals(String.valueOf(map.get("type")))) {
            jgUseRegistration.setUseUnitCreditCode(null);
            jgUseRegistration.setSequenceNbr(Long.valueOf(String.valueOf(map.get("sequenceNbr"))));
            this.getBaseMapper().updateById(jgUseRegistration);
        } else {

            // 业务管理设备信息保存
            JgUseRegistrationEq jgRelationEquip = new JgUseRegistrationEq();
            jgRelationEquip.setEquId(map.get("equipId").toString());
//            List<String> applicationFormCode = iCreateCodeServicevice.createApplicationFormCode(ApplicationFormTypeEnum.SYDJ.getCode(), 1);
//            jgUseRegistration.setApplyNo(applicationFormCode.get(0));
            ResponseModel<List<String>> listResponseModel = tzsServiceFeignClient.applicationFormCode(ApplicationFormTypeEnum.SYDJ.getCode(), 1);
            if(!ObjectUtils.isEmpty(listResponseModel)){
                jgUseRegistration.setApplyNo(listResponseModel.getResult().get(0));
            }
            jgUseRegistration.setAuditStatus("待提交");
            jgUseRegistration.setStatus(WorkFlowStatusEnum.USE_SUBMIT.getPass());
            this.save(jgUseRegistration);
            jgRelationEquip.setEquipTransferId(jgUseRegistration.getSequenceNbr().toString());
            jgRelationEquipMapper.insert(jgRelationEquip);
        }
        // 暂存历史表
        updateHistory(map, map.get("equipId").toString(), String.valueOf(jgUseRegistration.getSequenceNbr()), jgUseRegistration.getSupervisoryCode());
        if (!ObjectUtils.isEmpty(map.get("submit"))) {
            String instanceId = "";
            if (map.containsKey("instanceId")) {
                instanceId = map.get("instanceId").toString();
            } else {
                // 启动并执行流程
                instanceId = startByVariable();
//                jgUseRegistration.setInstanceStatus("1460532889249755137");
//                jgUseRegistration.setReceiveCompanyCode("610000");
                updateExecuteIds(instanceId, jgUseRegistration.getSequenceNbr(), "0");
            }

            if (!ObjectUtils.isEmpty(instanceId)) {
                // 执行流程
                flowExecute(jgUseRegistration.getSequenceNbr(), instanceId, "0", "");
                // 更新数据信息
                updateExecuteIds(instanceId, jgUseRegistration.getSequenceNbr(), "0");
            }
        }
    }

    public String startByVariable() {
        String instanceId = "";
        //启动流程
        try {
            ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
            dto.setProcessDefinitionKey("useRegistration");
            dto.setBusinessKey("submit");
            AjaxResult ajaxResult = Workflow.taskClient.startByVariable(dto);
            instanceId = ((Map) ajaxResult.get("data")).get("id").toString();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return instanceId;
    }

//    public String flowExecute(Long id,String instanceId, String operate, String comment, Boolean update) {
//        String role = "";
//        String taskName = "流程结束";
//        ArrayList<String> roleList = new ArrayList<>();
//        try {
//            JSONObject task = workFlowFeginService.getTaskNoAuth(instanceId);
//            JSONObject taskMessage = JSON.parseObject(JSON.toJSONString(task.get("data")));
//            String taskId = taskMessage.getString("id");
//            //组装信息
//            TaskResultDTO dto = new TaskResultDTO();
//            dto.setResultCode("approvalStatus");
//            dto.setTaskId(taskId);
//            dto.setComment(comment);
//            HashMap<String, Object> map = new HashMap<>();
//            map.put("approvalStatus", operate);
//            dto.setVariable(map);
//            //执行流程
//            Workflow.taskClient.completeByTask(taskId, dto);
//            // 查询下节点任务
//            JSONObject taskNoAuth = workFlowFeginService.getTaskNoAuth(instanceId);
//            if (!ObjectUtils.isEmpty(taskNoAuth.get("data"))) {
//                JSONObject nextTask = JSON.parseObject(JSON.toJSONString(taskNoAuth.get("data")));
//                String nextTaskId = nextTask.getString("id");
//                taskName = nextTask.getString("name");
//                AjaxResult taskGroupName = Workflow.taskClient.getTaskGroupName(nextTaskId);
//                JSONArray data = JSON.parseArray(JSON.toJSONString(taskGroupName.get("data")));
//                for (Object datum : data) {
//                    if (((Map) datum).containsKey("groupId")) {
//                        roleList.add(((Map) datum).get("groupId").toString());
//                    }
//                }
//            }
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//        role= String.join(",", roleList);
//        if (update) {
//            Boolean rollBack = "1".equals(operate) ? true : false;
//            updateStatus(id,instanceId, taskName, role, rollBack);
//        }
//        return role;
//    }

    public void updateExecuteIds(String instanceId, Long sequenceNbr, String operate) {
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        String role = "";
        String taskCode = FlowStatusEnum.TO_BE_FINISHED.getName();
        ArrayList<String> roleList = new ArrayList<>();
        JgUseRegistration jgUseRegistration = this.getBaseMapper().selectById(sequenceNbr);
        try {
            // 查询下节点任务

            JSONObject taskNoAuth = workFlowFeginService.getTaskNoAuth(instanceId);
            if (!ObjectUtils.isEmpty(taskNoAuth.get("data"))) {
                JSONObject nextTask = JSON.parseObject(JSON.toJSONString(taskNoAuth.get("data")));
                String nextTaskId = nextTask.getString("id");
                FeignClientResult<JSONObject> nodeInfo = workFlowFeginService.getNodeInfo(nextTaskId);
                JSONObject result = nodeInfo.getResult();
                Map<String, Object> taskInfo = (Map<String, Object>) result.get("taskInfo");
                taskCode = String.valueOf(taskInfo.get("taskDefinitionKey"));
                AjaxResult taskGroupName = Workflow.taskClient.getTaskGroupName(nextTaskId);
                JSONArray data = JSON.parseArray(JSON.toJSONString(taskGroupName.get("data")));
                for (Object datum : data) {
                    if (((Map) datum).containsKey("groupId")) {
                        roleList.add(((Map) datum).get("groupId").toString());
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (!FlowStatusEnum.TO_BE_FINISHED.getName().equals(taskCode)) {
            role = String.join(",", roleList);
            jgUseRegistration.setNextExecuteIds(role);
            jgUseRegistration.setPromoter(reginParams.getUserModel().getUserId());
            jgUseRegistration.setInstanceId(instanceId);
            if (!ObjectUtils.isEmpty(jgUseRegistration.getInstanceStatus())) {
                jgUseRegistration.setInstanceStatus(jgUseRegistration.getInstanceStatus() + "," + role);
            } else {
                jgUseRegistration.setInstanceStatus(role);
            }
            if ("0".equals(operate)) {
                // 通过操作
                jgUseRegistration.setStatus(WorkFlowStatusEnum.getMessage(taskCode).getPass());
            } else {
                // 驳回操作
                jgUseRegistration.setStatus(WorkFlowStatusEnum.getMessage(taskCode).getReject());
                jgUseRegistration.setPromoter(null);
            }

        } else {
            // 流程结束
            jgUseRegistration.setStatus(taskCode);
            if (!ObjectUtils.isEmpty(jgUseRegistration.getSupervisoryCode())) {
                // 生成使用登记证编号
                jgUseRegistration.setUseRegistrationCode(getCode(jgUseRegistration.getSupervisoryCode()));
                jgUseRegistration.setAuditPassDate(new Date());
            }
            // 更新设备信息
            updateEquipMessage(String.valueOf(sequenceNbr), jgUseRegistration.getUseRegistrationCode());
        }
        this.getBaseMapper().updateById(jgUseRegistration);

    }

    public void flowExecute(Long id, String instanceId, String operate, String comment) {
        try {
            JgUseRegistration jgUseRegistration = this.getBaseMapper().selectById(id);
            JSONObject task = workFlowFeginService.getTaskNoAuth(instanceId);
            JSONObject taskMessage = JSON.parseObject(JSON.toJSONString(task.get("data")));
            String taskId = taskMessage.getString("id");
            //组装信息
            TaskResultDTO dto = new TaskResultDTO();
            dto.setResultCode("approvalStatus");
            dto.setTaskId(taskId);
            dto.setComment(comment);
            HashMap<String, Object> map = new HashMap<>();
            map.put("approvalStatus", operate);
            if (jgUseRegistration.getStatus().equals(WorkFlowStatusEnum.USE_SUBMIT.getReject()) || jgUseRegistration.getStatus().equals(WorkFlowStatusEnum.USE_SUBMIT.getRollBack())) {
                map.put("approvalStatus", "提交");
            }
            dto.setVariable(map);
            //执行流程
            Workflow.taskClient.completeByTask(taskId, dto);
        } catch (Exception e) {
            e.printStackTrace();
        }
        // 更新下一步执行人
        updateExecuteIds(instanceId, id, operate);

    }


//    public void updateStatus(Long id , String instanceId, String taskName, String role, Boolean rollBack) {
//        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
//        LambdaQueryWrapper<JgUseRegistration> lambda = new QueryWrapper<JgUseRegistration>().lambda();
//        lambda.eq(JgUseRegistration::getSequenceNbr, id);
//        JgUseRegistration jgUseRegistration = this.getBaseMapper().selectOne(lambda);
//        if ("流程结束".equals(taskName)) {
//            jgUseRegistration.setStatus(taskName);
//            jgUseRegistration.setAuditStatus("已完成");
//        } else {
//            jgUseRegistration.setNextExecuteIds(role);
//            jgUseRegistration.setPromoter(reginParams.getUserModel().getUserId());
//            if (!ObjectUtils.isEmpty(jgUseRegistration.getInstanceStatus())) {
//                jgUseRegistration.setInstanceStatus(jgUseRegistration.getInstanceStatus() + "," + role);
//            } else {
//                jgUseRegistration.setInstanceStatus(role);
//            }
//            UseStatusEnum message = UseStatusEnum.getMessage(taskName);
//            jgUseRegistration.setStatus(message.getPass());
//        }
//        if (rollBack){
//            this.getBaseMapper().update(jgUseRegistration, lambda);
//            this.getBaseMapper().updatePromoter(jgUseRegistration.getSequenceNbr());
//        }else {
//            this.getBaseMapper().update(jgUseRegistration, lambda);
//        }
//    }

    public void withdraw(String instanceId) {
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        String taskCode = "";
        JgUseRegistration jgUseRegistration = new JgUseRegistration();
        LambdaQueryWrapper<JgUseRegistration> lambda = new QueryWrapper<JgUseRegistration>().lambda();
        lambda.eq(JgUseRegistration::getInstanceId, instanceId);
        ArrayList<String> roleList = new ArrayList<>();
        try {
            workFlowFeginService.rollBack(instanceId);
            JSONObject taskNoAuth = workFlowFeginService.getTaskNoAuth(instanceId);
            JSONObject nextTask = JSON.parseObject(JSON.toJSONString(taskNoAuth.get("data")));

            if (!ObjectUtils.isEmpty(taskNoAuth.get("data"))) {
                String nextTaskId = nextTask.getString("id");
                FeignClientResult<JSONObject> nodeInfo = workFlowFeginService.getNodeInfo(nextTaskId);
                JSONObject result = nodeInfo.getResult();
                Map<String, Object> taskInfo = (Map<String, Object>) result.get("taskInfo");
                taskCode = String.valueOf(taskInfo.get("taskDefinitionKey"));
                AjaxResult taskGroupName = Workflow.taskClient.getTaskGroupName(nextTaskId);
                JSONArray data = JSON.parseArray(JSON.toJSONString(taskGroupName.get("data")));
                for (Object datum : data) {
                    if (((Map<?, ?>) datum).containsKey("groupId")) {
                        roleList.add(((Map<?, ?>) datum).get("groupId").toString());
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (!ObjectUtils.isEmpty(taskCode)) {

            jgUseRegistration.setStatus(WorkFlowStatusEnum.getMessage(taskCode).getRollBack());
        }
        String join = String.join(",", roleList);
        jgUseRegistration.setPromoter(reginParams.getUserModel().getUserId());
        jgUseRegistration.setNextExecuteIds(join);
        this.update(jgUseRegistration, lambda);
    }

    public void deleteBatch(List<Long> ids) {
        JgUseRegistration jgUseRegistration = new JgUseRegistration();
        jgUseRegistration.setIsDelete(true);
        LambdaQueryWrapper<JgUseRegistration> lambda = new QueryWrapper<JgUseRegistration>().lambda();
        lambda.in(JgUseRegistration::getSequenceNbr, ids);
        this.update(jgUseRegistration, lambda);
    }

    public Map<String, Object> getDetail(String id, Long sequenceNbr) {
        if (!ObjectUtils.isEmpty(sequenceNbr)){
            JgUseRegistration jgUseRegistration = this.getBaseMapper().selectById(sequenceNbr);
            LambdaQueryWrapper<JgRegistrationHistory> lambda = new QueryWrapper<JgRegistrationHistory>().lambda();
            lambda.eq(JgRegistrationHistory::getCurrentDocumentId, sequenceNbr);
            lambda.eq(JgRegistrationHistory::getEquId, id);
            JgRegistrationHistory jgRegistrationHistory = jgRegistrationHistoryService.getBaseMapper().selectOne(lambda);
            JSONObject jsonObject = JSONObject.parseObject(jgRegistrationHistory.getChangeData());
            jsonObject.put("receiveOrgCode", jgUseRegistration.getReceiveCompanyCode()+"_"+jgUseRegistration.getReceiveOrgName());
            return jsonObject;
        }
        Map<String, Object> detail = this.baseMapper.getDetail(id);
        Map<String, Object> inspectDetail = this.baseMapper.getInspectDetail(id);
        Map<String, Object> useDetail = this.baseMapper.getUseDetail(id);
        if (!ObjectUtils.isEmpty(inspectDetail)){
            detail.putAll(inspectDetail);
        }
        if (!ObjectUtils.isEmpty(useDetail)){
            detail.putAll(useDetail);
        }
        detail.put("proDuctPhoto", JSON.parse(String.valueOf(detail.get("proDuctPhoto"))));
        detail.put("factoryStandard", JSON.parse(String.valueOf(detail.get("factoryStandard"))));
        detail.put("productQualityYieldProve", JSON.parse(String.valueOf(detail.get("productQualityYieldProve"))));
        detail.put("insUseMaintainExplanin", JSON.parse(String.valueOf(detail.get("insUseMaintainExplanin"))));
        detail.put("inspectReport", JSON.parse(String.valueOf(detail.get("inspectReport"))));
        return detail;
    }

    /**
     * 参数为监管码
     *
     * @param supervisoryCode
     * @return
     */
    public String getCode(String supervisoryCode) {
        if (!ObjectUtils.isEmpty(supervisoryCode) && supervisoryCode.length() > 5) {
            String name = EquipTypeEnum.getMessage(supervisoryCode.substring(1, 2));
            String type = supervisoryCode.substring(2, 4);
            String city = supervisoryCode.substring(0, 1);
            ResponseModel<String> stringResponseModel = tzsServiceFeignClient.useRegistrationCode(name + type + "陕" + city);
            return stringResponseModel.getResult();
        }
        return null;
    }
}