package com.yeejoin.amos.boot.module.common.api.enums;

import lombok.Getter;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;

@Getter
public enum UnitTypeEnum {
    //type 1生产单位 2使用单位 3充装单位 4检验检测机构
    //制造单位
    ZZDW("制造单位","1236","1"),
    //设计单位
    SJDW("设计单位","1235","1"),
    //安改维单位
    AGWDW("安装改造维修单位","1234","1"),
    //使用单位
    SYDW("使用单位","1232","2"),
    //充装单位
    CZDW("充装单位","1231","3"),
    //检验检测机构
    JYJCJG("检验检测机构","1233","4"),

    ;

    String name;
    String code;
    String type;

    private UnitTypeEnum(String name, String code, String type) {
        this.name = name;
        this.code = code;
        this.type = type;
    }

    public static List<String> getNameListByType(String type) {
        List<String> list = new ArrayList<>();
        for (UnitTypeEnum testEnum : EnumSet.allOf(UnitTypeEnum.class)) {
            if (testEnum.getType().equals(type)) {
                list.add(testEnum.getName());
            }
        }
        return list;
    }


}
