package com.yeejoin.amos.boot.module.statistics.api.enums;

import java.util.function.Function;

public enum MatinfoEnum {

    EXCEL("/public/webico/resources/上传-excl.png", (str) -> str.equals("xls") || str.equals("xlsx")),
    PDF("/public/webico/resources/上传-pdf.png", (str) -> str.equals("pdf")),
    PPT("/public/webico/resources/上传-ppt.png", (str) -> str.equals("ppt")),
    WOED("/public/webico/resources/上传-word.png", (str) -> str.equals("doc") || str.equals("docx") || str.equals("txt")),
    IMAGE("/public/webico/resources/上传-图片.png", (str) -> false),
    VIDEO("/public/webico/resources/上传-视频.png", (str) -> str.equals("mp4") || str.equals("avi") || str.equals("flv"));

    private String icon;

    private Function<String, Boolean> buildFunction;

    MatinfoEnum() {
    }

    MatinfoEnum(String icon, Function<String, Boolean> buildFunction) {
        this.icon = icon;
        this.buildFunction = buildFunction;
    }

    public String getIcon() {
        return icon;
    }

    public Function<String, Boolean> getBuildFunction() {
        return buildFunction;
    }

    public static MatinfoEnum getIconUrl(String suffix){
        for (MatinfoEnum value : values()) {
            if (value.getBuildFunction().apply(suffix)) {
                return value;
            }
        }
        return IMAGE;
    }
}
