package com.yeejoin.amos.boot.module.elevator.api.enums;

/**
 * 信息来源枚举（1：警情报送，2：救援过程，3：警情编辑）
 */
public enum SourcesInfoEnum {

    Submit(1, "警情报送"), Process(2, "救援过程"), Edit(3, "警情编辑");

    /**
     * 编码
     */
    private final Integer code;

    /**
     * 名称
     */
    private final String name;


    // 构造方法
    SourcesInfoEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public static SourcesInfoEnum getEnum(Integer code) {
        for (SourcesInfoEnum liftDirectionEnum : SourcesInfoEnum.values()) {
            if (liftDirectionEnum.getCode().equals(code)) {
                return liftDirectionEnum;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
