package com.yeejoin.amos.boot.module.jyjc.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.CompanyBo;
import com.yeejoin.amos.boot.module.common.api.constant.TZSCommonConstant;
import com.yeejoin.amos.boot.module.common.api.dto.BaseEnterpriseCertDto;
import com.yeejoin.amos.boot.module.jyjc.api.common.BizCommonConstant;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionHistory;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcOpeningApplication;
import com.yeejoin.amos.boot.module.jyjc.api.model.JyjcBizManageModel;
import com.yeejoin.amos.boot.module.jyjc.api.model.JyjcOpeningApplicationModel;
import com.yeejoin.amos.boot.module.ymt.api.entity.BaseUnitLicence;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

@Service
@RequiredArgsConstructor
@Slf4j
public class JyjcBizManageServiceImpl {

    private static final String TY = "停用";

    private static final String QY = "启用";

    private final JyjcOpeningApplicationServiceImpl openingApplicationService;

    private final RedissonClient redissonClient;

    public IPage<?> pageList(Page<JyjcBizManageModel> page, CompanyBo company, JyjcOpeningApplicationModel model) {
        Page<JyjcOpeningApplication> pageApp = new Page<>(page.getCurrent(), page.getSize());
        LambdaQueryWrapper<JyjcOpeningApplication> queryWrapper = new LambdaQueryWrapper<>();
        this.setIdentify(company, queryWrapper);
        queryWrapper.eq(JyjcOpeningApplication::getStatus, FlowStatusEnum.TO_BE_FINISHED.getName());
        queryWrapper.like(StringUtils.isNotEmpty(model.getUnitCodeName()), JyjcOpeningApplication::getUnitCodeName, model.getUnitCodeName());
        queryWrapper.eq(StringUtils.isNotEmpty(model.getOpenBizType()), JyjcOpeningApplication::getOpenBizType, model.getOpenBizType());
        IPage<JyjcOpeningApplication> res = openingApplicationService.page(pageApp, queryWrapper);
        List<JyjcBizManageModel> manageModels = res.getRecords().stream().map(r -> {
            JyjcBizManageModel bizManageModel = BeanUtil.copyProperties(r, JyjcBizManageModel.class);
            setAreaStatusByIdentify(company, r, bizManageModel);
            return bizManageModel;
        }).collect(Collectors.toList());
        page.setRecords(manageModels);
        page.setTotal(res.getTotal());
        return page;
    }

    private static void setAreaStatusByIdentify(CompanyBo company, JyjcOpeningApplication r, JyjcBizManageModel bizManageModel) {
        if (TZSCommonConstant.SHAN_XI_REGION_CODE.equals(company.getCompanyCode())) {
            bizManageModel.setAreaStatus(QY);
        } else {
            if (r.getExclusionRegion() != null && r.getExclusionRegion().contains(company.getCompanyCode())) {
                bizManageModel.setAreaStatus(TY);
            } else {
                bizManageModel.setAreaStatus(QY);
            }
        }
    }

    private void setIdentify(CompanyBo company, LambdaQueryWrapper<JyjcOpeningApplication> queryWrapper) {
        if (!TZSCommonConstant.SHAN_XI_REGION_CODE.equals(company.getCompanyCode())) {
            queryWrapper.and(w ->
                    w.like(JyjcOpeningApplication::getDetectionRegion, company.getCompanyCode())
                            .or()
                            .like(JyjcOpeningApplication::getExclusionRegion, company.getCompanyCode()));
        }
    }

    public Boolean enable(String appSeq, CompanyBo company) {
        log.info("启用企业区域权限, appSeq: {}, company: {}", appSeq, company.getCompanyCode());
        String lockKey = "app:region:lock:" + appSeq;
        RLock lock = redissonClient.getLock(lockKey);
        try {
            boolean isLocked = lock.tryLock(0, 180, TimeUnit.SECONDS);
            // 解决并发问题：多个人同时操作一个单据
            if (!isLocked) {
                throw new BadRequest("其他机构同时在操作该业务，请稍后重试！");
            }
            JyjcOpeningApplication openingApplication = openingApplicationService.getById(appSeq);
            List<String> detectionRegion = openingApplication.getDetectionRegion();
            Set<String> detectionRegionSet = new HashSet<>(detectionRegion);
            detectionRegionSet.add(company.getCompanyCode());
            List<String> exclusionRegion = openingApplication.getExclusionRegion();
            if (exclusionRegion != null) {
                exclusionRegion.remove(company.getCompanyCode());
            }
            openingApplicationService.update(new LambdaUpdateWrapper<JyjcOpeningApplication>()
                    .eq(BaseEntity::getSequenceNbr, appSeq)
                    .set(JyjcOpeningApplication::getDetectionRegion, detectionRegionSet)
                    .set(JyjcOpeningApplication::getExclusionRegion, exclusionRegion));

        } catch (InterruptedException e) {
            log.error("启用企业区域失败：{}", e.getMessage(), e);
        } finally {
            if (lock.isLocked() && lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
        return Boolean.TRUE;
    }

    public Boolean disable(String appSeq, CompanyBo company) {
        log.info("禁用企业区域权限, appSeq: {}, company: {}", appSeq, company.getCompanyCode());
        String lockKey = "app:region:lock:" + appSeq;
        RLock lock = redissonClient.getLock(lockKey);
        try {
            boolean isLocked = lock.tryLock(0, 180, TimeUnit.SECONDS);
            // 解决并发问题：解决并发问题：多个人同时操作一个单据
            if (!isLocked) {
                throw new BadRequest("其他机构同时在操作该业务，请稍后重试！");
            }
            JyjcOpeningApplication openingApplication = openingApplicationService.getById(appSeq);
            List<String> detectionRegion = openingApplication.getDetectionRegion();
            if (detectionRegion != null) {
                detectionRegion.remove(company.getCompanyCode());
            }
            List<String> exclusionRegion = openingApplication.getExclusionRegion();
            Set<String> exclusionRegionSet = new HashSet<>(exclusionRegion);
            exclusionRegion.add(company.getCompanyCode());
            openingApplicationService.update(new LambdaUpdateWrapper<JyjcOpeningApplication>()
                    .eq(BaseEntity::getSequenceNbr, appSeq)
                    .set(JyjcOpeningApplication::getDetectionRegion, detectionRegion)
                    .set(JyjcOpeningApplication::getExclusionRegion, exclusionRegionSet));
        } catch (InterruptedException e) {
            log.error("禁用企业区域失败：{}", e.getMessage(), e);
        } finally {
            if (lock.isLocked() && lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
        return Boolean.TRUE;
    }

    public Boolean licenceEdit(String appSeq, List<BaseUnitLicence> licences) {

//        openingApplications.forEach(jyjcOpeningApplication -> {
//            JyjcInspectionHistory history = inspectionHistoryService.getBySSeq(jyjcOpeningApplication.getSequenceNbr());
//            if (history != null) {
//                JSONObject hisData = history.getHistoryData();
//                List<BaseEnterpriseCertDto> certDtos = hisData.getJSONArray(BizCommonConstant.UNIT_LICENCE_KEY).toJavaList(BaseEnterpriseCertDto.class);
        return Boolean.TRUE;

    }

    public List<BaseUnitLicence> licenceDetail(String appSeq) {
        return null;
    }
}
