package com.yeejoin.amos.supervision.common.enums;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author DELL
 */

public enum DangerCheckTypeLevelEnum {

    DEPARTMENT("单位级", "1",  "department"),
    COMPANY("公司级", "2", "company"),
    EXTERNAL("外部消防单位", "3", "external"),
	/* OTHER("其他", "4", "external") */
    ;

    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private String code;

    /**
     * 执行控制条件
     */
    private String condition;

    DangerCheckTypeLevelEnum(String name, String code, String condition) {
        this.name = name;
        this.code = code;
        this.condition = condition;
    }

    /**
     * 获取枚举
     * @param code 编号
     * @return DangerCheckTypeLevelEnum
     * @throws Exception
     */
    public static DangerCheckTypeLevelEnum getEumByCode(String code) throws Exception {
        Optional<DangerCheckTypeLevelEnum> op = Arrays.stream(DangerCheckTypeLevelEnum.values()).filter(e->e.code.equals(code)).findFirst();
        return op.orElseThrow(()->new Exception("不存在"));
    }

    public static List<Map<String, Object>> getEnumList() {
        return Arrays.stream(DangerCheckTypeLevelEnum.values()).map(e -> {
            Map<String, Object> map = new HashMap<>();
            map.put("code", e.getCode());
            map.put("name", e.getName());
            return map;
        }).collect(Collectors.toList());
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String  getCondition() {
        return condition;
    }
}
