package com.yeejoin.amos.boot.module.hygf.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 商务信息
 *
 * @author system_generator
 * @date 2023-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="CommercialDto", description="商务信息")
public class CommercialDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "商务类型")
    private String type;

    @ApiModelProperty(value = "申请人")
    private String applicant;

    @ApiModelProperty(value = "身份证号")
    private String idCard;

    @ApiModelProperty(value = "申请人联系电话")
    private String telephone;

    @ApiModelProperty(value = "省市区")
    private String projectAddress;

    @ApiModelProperty(value = "设备信息")
    private String device;

    @ApiModelProperty(value = "电子系统造价")
    private Float cost;

    @ApiModelProperty(value = "安装规模")
    private String scale;

    @ApiModelProperty(value = "法务类型")
    private String legalType;

    @ApiModelProperty(value = "有效联系电话")
    private String legalContactTelephone;

    @ApiModelProperty(value = "紧急联系人")
    private String legalEmergentTelephone;

    @ApiModelProperty(value = "结婚证文件标识")
    private String marriageCredit;

    @ApiModelProperty(value = "房产证文件标识")
    private String realEstateCredit;

    @ApiModelProperty(value = "身份证正反面文件标识")
    private String idCardCredit;

    @ApiModelProperty(value = "户口本文件标识")
    private String householdBookCredit;

    @ApiModelProperty(value = "手持身份证文件标识")
    private String handIdCardCredit;

    @ApiModelProperty(value = "踏勘照片文件标识")
    private String surveyPhotosWeb;

    @ApiModelProperty(value = "组件平面图与组串连线图文件标识")
    private String formationWeb;

    @ApiModelProperty(value = "房屋所有权继承说明文件标识")
    private String inheritWeb;

    @ApiModelProperty(value = "户用光伏电站项目合作协议文件标识")
    private String agreementWeb;

    @ApiModelProperty(value = "用户手持身份证照片文件标识")
    private String handIdCardLegal;

    @ApiModelProperty(value = "法人营业执照文件标识")
    private String licenseLegal;

    @ApiModelProperty(value = "法定代理人身份证文件标识")
    private String agentLegal;

    @ApiModelProperty(value = "房产证明文件或乡镇街道土管部门房屋产权证明文件文件标识")
    private String realEstateLegal;

    @ApiModelProperty(value = "房屋屋顶租赁协议/户用光伏共建开发协议文件标识")
    private String houseAgreementLegal;

    @ApiModelProperty(value = "法人的企业征信报告、工商内档文件标识")
    private String creditReportLegal;

    @ApiModelProperty(value = "项目备案证文件标识")
    private String filingsLegal;

    @ApiModelProperty(value = " 省市区详细地址")
    private String projectAddressDetail;

    @ApiModelProperty(value = "勘察表id")
    private Long surveyInformationId;
}
