package com.yeejoin.precontrol.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.precontrol.common.entity.CompanyEvaluationLog;
import com.yeejoin.precontrol.common.entity.UserEvaluationLog;
import com.yeejoin.precontrol.common.service.ICompanyEvaluationLogService;
import com.yeejoin.precontrol.common.utils.NameUtils;
import com.yeejoin.precontrol.common.vo.CompanyEvaluationLogVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;


/**
 * 分包商评价记录表
 *
 * @author tb
 * @date 2021-01-28
 */
@RestController
@Api(tags = "分包商评价记录表Api")
@RequestMapping(value = "/company-evaluation-log", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class CompanyEvaluationLogController {

    @Autowired
    ICompanyEvaluationLogService iCompanyEvaluationLogService;

    /**
     * 新增分包商评价记录表
     *
     * @return
     */
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增分包商评价记录表", notes = "新增分包商评价记录表")
    public boolean saveCompanyEvaluationLog(HttpServletRequest request, @RequestBody CompanyEvaluationLog companyEvaluationLog) {
        Optional.ofNullable(companyEvaluationLog.getEvaluationUserId()).orElseThrow(() -> new BadRequest("评价人不能为空"));
        Optional.ofNullable(companyEvaluationLog.getCompanyId()).orElseThrow(() -> new BadRequest("分包商不能为空"));
        Optional.ofNullable(companyEvaluationLog.getRate()).orElseThrow(() -> new BadRequest("评分不能为空"));
        return iCompanyEvaluationLogService.save(companyEvaluationLog);
    }

    /**
     * 根据id删除
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public boolean deleteById(HttpServletRequest request, @PathVariable Long id) {
        return iCompanyEvaluationLogService.removeById(id);
    }

    /**
     * 根据分包商id查询列表分页
     *
     * @return
     */
    @RequestMapping(value = "/{companyId}/page/list", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据分包商id查询列表分页", notes = "根据分包商id查询列表分页")
    public IPage<CompanyEvaluationLog> listByCompanyId(String pageNum, String pageSize, @PathVariable String companyId) {
        return iCompanyEvaluationLogService.listByCompanyId(pageNum, pageSize, companyId);
    }

    /**
     * 根据分包商id查询列表分页
     *
     * @return
     */
    @RequestMapping(value = "/{companyId}/page/list/vo", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据分包商id查询列表分页", notes = "根据分包商id查询列表分页")
    public IPage<CompanyEvaluationLogVo> listVoByCompanyId(String pageNum, String pageSize, @PathVariable String companyId) {
        return iCompanyEvaluationLogService.listVoByCompanyId(pageNum, pageSize, companyId);
    }

    /**
     * 根据被评价人id查询列表分页
     *
     * @return
     */
    @RequestMapping(value = "/{taskId}/list", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据被任务id查询列表分页", notes = "根据被任务id查询列表分页")
    public List<CompanyEvaluationLog> listByTaskId(@PathVariable String taskId) {
        return iCompanyEvaluationLogService.listByTaskId(taskId);
    }

    /**
     * 列表分页查询
     *
     * @return
     */
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
    public IPage<CompanyEvaluationLog> listPage(String pageNum, String pageSize,
                                                CompanyEvaluationLog companyEvaluationLog) {
        Page<CompanyEvaluationLog> pageBean;
        QueryWrapper<CompanyEvaluationLog> companyEvaluationLogQueryWrapper = new QueryWrapper<>();
        Class<? extends CompanyEvaluationLog> aClass = companyEvaluationLog.getClass();
        Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
            try {
                field.setAccessible(true);
                Object o = field.get(companyEvaluationLog);
                if (o != null) {
                    Class<?> type = field.getType();
                    String name = NameUtils.camel2Underline(field.getName());
                    if (type.equals(Integer.class)) {
                        Integer fileValue = (Integer) field.get(companyEvaluationLog);
                        companyEvaluationLogQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(Long.class)) {
                        Long fileValue = (Long) field.get(companyEvaluationLog);
                        companyEvaluationLogQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(String.class)) {
                        String fileValue = (String) field.get(companyEvaluationLog);
                        companyEvaluationLogQueryWrapper.eq(name, fileValue);
                    } else {
                        String fileValue = (String) field.get(companyEvaluationLog);
                        companyEvaluationLogQueryWrapper.eq(name, fileValue);
                    }
                }
            } catch (Exception e) {
            }
        });
        IPage<CompanyEvaluationLog> page;
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        page = iCompanyEvaluationLogService.page(pageBean, companyEvaluationLogQueryWrapper);
        return page;
    }
}