package com.yeejoin.precontrol.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.precontrol.common.dto.CommonPageableDto;
import com.yeejoin.precontrol.common.dto.ProjectHistroyDto;
import com.yeejoin.precontrol.common.entity.ProjectHistory;
import com.yeejoin.precontrol.common.service.IProjectHistoryService;
import com.yeejoin.precontrol.common.utils.FileHelper;
import com.yeejoin.precontrol.common.vo.ProjectHistoryVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.UUID;


/**
 * 项目历史轨迹
 *
 * @author duanwei
 * @date 2020-07-16
 */
@RestController
@Api(tags = "项目历史轨迹Api")
@RequestMapping(value = "/project-history", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class ProjectHistoryController {

    /**
     * 项目历史服务
     */
    @Autowired
    IProjectHistoryService iProjectHistoryService;


    /**
     * 新增项目历史轨迹
     *
     * @return
     */
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增项目历史轨迹", notes = "新增项目历史轨迹")
    public boolean saveProjectHistory(HttpServletRequest request, @RequestBody ProjectHistory projectHistory) {
        return iProjectHistoryService.save(projectHistory);
    }

    /**
     * 根据id删除
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public boolean deleteById(HttpServletRequest request, @PathVariable Long id) {
        return iProjectHistoryService.removeById(id);
    }


    /**
     * 修改项目历史轨迹
     *
     * @return
     */
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "修改项目历史轨迹", notes = "修改项目历史轨迹")
    public boolean updateByIdProjectHistory(HttpServletRequest request, @RequestBody ProjectHistory projectHistory) {
        return iProjectHistoryService.updateById(projectHistory);
    }


    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/{id}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
    public ProjectHistory selectById(HttpServletRequest request, @PathVariable Long id) {
        return iProjectHistoryService.getById(id);
    }


    /**
     * 列表分页查询
     *
     * @return
     */
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
    public Object listPage(@ApiParam(value = "分页条件 isAll=0 具体分页必传") CommonPageableDto pageable,
                           @ApiParam(value = "查询参数") ProjectHistroyDto projectHistroyDto,
                           @ApiParam(value = "类型 0查询列表 1 导出列表") @RequestParam Long operType,
                           @ApiParam(value = "查询Ids") @RequestParam(required = false) List<Long> ids,
                           HttpServletResponse response) {
        String fileName = UUID.randomUUID().toString() + ".xls";
        if (null != ids && ids.size() > 0) {
            projectHistroyDto.setIds(ids);
        }
        IPage<ProjectHistoryVo> page = iProjectHistoryService.listByPage(pageable, projectHistroyDto);
        if (operType == 1) {
            List<ProjectHistoryVo> excelList = page.getRecords();
            FileHelper.exportExcel(excelList, "项目历史轨迹", "项目历史轨迹信息", ProjectHistoryVo.class, fileName, response);
            return null;
        } else {
            return page;
        }
    }
}


