package com.yeejoin.amos.boot.module.jg.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 使用登记状态西悉尼
 */
@Getter
@AllArgsConstructor
public enum MaintenceStatusEnum {

    SUBMIT("使用单位提交", "submit", "使用单位待提交", "维保单位已驳回", "使用单位撤回"),
    RECEIVE("维保单位审核确认", "receive", "维保单位待受理", "监管单位已驳回", "维保单位撤回"),
    PRELIMINARY("监管单位审核", "preliminary", "监管单位待受理", "", "");




    private final String name;

    private final String code;

    private final String pass;

    private final String reject;

    private final String rollBack;



    public static MaintenceStatusEnum getMessage(String name){
        for (MaintenceStatusEnum constants : values()) {
            if (constants.getName().equals(name)) {
                return constants;
            }
        }
        return null;
    }
}
