package com.yeejoin.amos.boot.module.jg.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * 使用登记状态西悉尼
 */
@Getter
@AllArgsConstructor
public enum UseStatusEnum {

    SUBMIT("使用单位提交", "submit", "使用单位待提交"),
    RECEIVE("一级受理", "receive", "一级待受理"),
    PRELIMINARY("二级受理", "preliminary", "二级待受理"),
    REEXAMINE("三级受理", "reexamine", "三级待受理");



    private final String name;

    private final String code;

    private final String pass;



    public static UseStatusEnum getMessage(String name){
        for (UseStatusEnum constants : values()) {
            if (constants.getName().equals(name)) {
                return constants;
            }
        }
        return null;
    }
}
