package com.yeejoin.amos.boot.module.jg.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jg.biz.service.IIdxBizJgRegisterInfoService;
import com.yeejoin.amos.boot.module.ymt.api.dto.IdxBizJgRegisterInfoDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

/**
 * 设备注册
 *
 * @author Provence
 * @version v1.0
 * @date 2023/12/13 14:37
 */
@RestController
@Api (tags = "设备注册Api")
@RequestMapping (value = "/equipment-register")
public class IdxBizJqEquipmentRegisterController extends BaseController {
    @Autowired
    IIdxBizJgRegisterInfoService idxBizJgRegisterInfoService;

    /**
     * 设备注册和更新信息
     * @param paramMap
     * @return
     */
    @TycloudOperation (ApiLevel = UserType.AGENCY)
    @PostMapping (value = "/submit")
    @ApiOperation (httpMethod = "POST", value = "设备注册和更新信息", notes = "设备注册和更新信息")
    public ResponseModel<Object> submit(@RequestBody Map<String, Object> paramMap) {
        return ResponseHelper.buildResponse(idxBizJgRegisterInfoService.equipmentRegisterSubmit(paramMap));
    }


    /**
     * 根据recordList批量删除设备注册信息
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/deleteBatch")
    @ApiOperation(httpMethod = "POST", value = "批量删除设备注册信息", notes = "批量删除设备注册信息")
    public ResponseModel<Boolean> deleteByRecordList(@RequestBody Map<String,Object> map){
        return ResponseHelper.buildResponse(idxBizJgRegisterInfoService.batchDeleteByRecord(map));
    }

    /**
     * 查询设备注册信息详情
     * @param record
     * @return 返回由页签的key包裹详情对象
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping (value = "/{record}")
    @ApiOperation(httpMethod = "GET", value = "根据record查询设备注册信息详情", notes = "根据record查询设备注册信息详情")
    public ResponseModel<Object> selectOne(@PathVariable String record) {
        return ResponseHelper.buildResponse(idxBizJgRegisterInfoService.getEquipmentRegisterByRecord(record));
    }


    /**
     * 查询设备注册信息详情
     * @param record
     * @return 只返回详情对象
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping (value = "/detail")
    @ApiOperation(httpMethod = "GET", value = "根据record查询设备注册信息详情", notes = "根据record查询设备注册信息详情")
    public ResponseModel<Map<String, Object>> getDetail(@RequestParam String record) {
        return ResponseHelper.buildResponse(idxBizJgRegisterInfoService.getDetailByRecord(record));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping (value = "/detailFieldCamelCase")
    @ApiOperation(httpMethod = "GET", value = "根据record查询设备注册信息详情，返回字段驼峰命名", notes = "根据record查询设备注册信息详情，返回字段驼峰命名")
    public ResponseModel<Map<String, Object>> getDetailFieldCamelCase(@RequestParam String record) {
        return ResponseHelper.buildResponse(idxBizJgRegisterInfoService.getDetailFieldCamelCaseByRecord(record));
    }

    /**
     * 查询设备注册列表
     * @param map
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "设备注册信息分页查询", notes = "设备注册信息分页查询")
    public ResponseModel<Page<JSONObject>> queryForPage( @RequestParam Map<String,Object> map) {
        JSONObject jsonObject = new JSONObject(map);
        return ResponseHelper.buildResponse(idxBizJgRegisterInfoService.queryForEquipmentRegisterPage(jsonObject));
    }

}
