package com.yeejoin.amos.boot.module.jg.biz.controller;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jg.api.dto.JgEquipTransferDto;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgEquipTransferServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

/**
 * 设备移交
 *
 * @author system_generator
 * @date 2023-12-20
 */
@RestController
@Api(tags = "设备移交Api")
@RequestMapping(value = "/jg-equip-transfer")
public class JgEquipTransferByWorkFlowController extends BaseController {

    @Autowired
    JgEquipTransferServiceImpl jgEquipTransferServiceImpl;

    private static final String TABLE_PAGE_ID = "1734141426742095873";

    /**
     * 受理
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/accept")
    @ApiOperation(httpMethod = "POST", value = "设备移交受理", notes = "设备移交受理")
    public ResponseModel<JgEquipTransferDto> accept(@RequestBody Map<String, Object> model, String op) {
        LinkedHashMap model1 = (LinkedHashMap)model.get("model");
        LinkedHashMap equipTransferInfo = (LinkedHashMap)model1.get(TABLE_PAGE_ID);
        JgEquipTransferDto jgEquipTransferDto = JSON.parseObject(JSON.toJSONString(equipTransferInfo), JgEquipTransferDto.class);
        jgEquipTransferServiceImpl.accept(jgEquipTransferDto,op);
        return ResponseHelper.buildResponse(null);
    }

    /**
     * 设备移交撤销
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/cancel")
    @ApiOperation(httpMethod = "POST", value = "设备移交撤销", notes = "设备移交撤销")
    public ResponseModel<JgEquipTransferDto> cancel(@RequestBody Map<String, Object> model) {
        JgEquipTransferDto equipTransferInfo = BeanUtil.mapToBean(((LinkedHashMap) model.get(TABLE_PAGE_ID)), JgEquipTransferDto.class, true);
        if (Objects.isNull(equipTransferInfo)) {
            throw new IllegalArgumentException("参数equipTransferInfo不能为空");
        }
        jgEquipTransferServiceImpl.cancel(equipTransferInfo);
        return ResponseHelper.buildResponse(equipTransferInfo);
    }
}

