package com.yeejoin.amos.boot.module.jg.biz.controller;

import cn.hutool.core.bean.BeanUtil;
import com.yeejoin.amos.boot.module.jg.api.entity.JgEquipTransfer;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.*;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgEquipTransferServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jg.api.dto.JgEquipTransferDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 设备移交
 *
 * @author system_generator
 * @date 2023-12-20
 */
@RestController
@Api(tags = "设备移交Api")
@RequestMapping(value = "/jg-equip-transfer")
public class JgEquipTransferController extends BaseController {

    private static final String TABLE_PAGE_ID = "1734141426742095873";

    @Autowired
    JgEquipTransferServiceImpl jgEquipTransferServiceImpl;

    /**
     * 新增设备移交
     *
     * @return String
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增设备移交", notes = "新增设备移交")
    public ResponseModel<Object> save(@RequestParam String submitType, @RequestBody Map<String, JgEquipTransferDto> modelMap) {
        jgEquipTransferServiceImpl.saveOrUpdateModel(submitType, modelMap.get(TABLE_PAGE_ID), getSelectedOrgInfo());
        return ResponseHelper.buildResponse("ok");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/update")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新设备移交", notes = "根据sequenceNbr更新设备移交")
    public ResponseModel<JgEquipTransferDto> updateBySequenceNbr(@RequestParam String submitType, @RequestBody Map<String, Object> modelMap, @RequestParam(value = "op", required = false) String op) {
        JgEquipTransferDto equipTransferDto = BeanUtil.mapToBean(((LinkedHashMap) modelMap.get(TABLE_PAGE_ID)), JgEquipTransferDto.class, true);
        if (Objects.isNull(equipTransferDto)) {
            throw new IllegalArgumentException("参数equipTransferDto不能为空");
        }
        return ResponseHelper.buildResponse(jgEquipTransferServiceImpl.updateEquipTransfer(submitType, equipTransferDto, op));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/delete")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除设备移交", notes = "根据sequenceNbr删除设备移交")
    public ResponseModel<Boolean> deleteBySequenceNbr(@RequestParam(value = "sequenceNbr") Long[] sequenceNbr) {
        return ResponseHelper.buildResponse(jgEquipTransferServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 批量删除
     *
     * @param ids 主键
     * @return ResponseModel
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/deleteBatch")
    @ApiOperation(httpMethod = "DELETE", value = "批量删除设备移交", notes = "批量删除设备移交")
    public ResponseModel<Object> deleteBySequenceNbr(@RequestParam String ids) {
        if (StringUtils.isEmpty(ids)) {
            throw new RuntimeException("请选择需要删除的行！");
        }
        return ResponseHelper.buildResponse(jgEquipTransferServiceImpl.removeByIds(Arrays.asList(ids.split(","))));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return Map
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/details")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个设备移交", notes = "根据sequenceNbr查询单个设备移交")
    public ResponseModel<Map<String, Map<String, Object>>> selectOne(@RequestParam Long sequenceNbr) {
        return ResponseHelper.buildResponse(jgEquipTransferServiceImpl.queryBySequenceNbr(sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param size    每页大小
     * @return Page
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "设备移交分页查询", notes = "设备移交分页查询")
    public ResponseModel<Page<JgEquipTransferDto>> queryForPage(@RequestParam(value = "current") int current,
                                                                @RequestParam(value = "size") int size,
                                                                @ApiParam(value = "类型：enterprise-企业端、supervision-监管端", required = true) @RequestParam(value = "type", defaultValue = "enterprise") String type,
                                                                @RequestBody(required = false) JgEquipTransferDto dto) {
        Page<JgEquipTransfer> page = new Page<>(current, size);
        return ResponseHelper.buildResponse(jgEquipTransferServiceImpl.queryForJgEquipTransferPage(page, dto, type, getSelectedOrgInfo()));
    }
}

