package com.yeejoin.amos.boot.module.jg.biz.controller;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jg.api.dto.JgScrapCancelDto;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgScrapCancelServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.*;

/**
 * 设备注销报废
 *
 * @author system_generator
 * @date 2023-12-20
 */
@RestController
@Api(tags = "设备注销报废Api")
@RequestMapping(value = "/jg-scrap-cancel")
public class JgScrapCancelController extends BaseController {

    @Autowired
    JgScrapCancelServiceImpl jgScrapCancelService;


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增/新增并提交", notes = "新增/新增并提交")
    public ResponseModel<Object> save(@RequestParam String submitType, @RequestBody Map<String, JSONObject> model) {
        jgScrapCancelService.save(submitType, model);
        return ResponseHelper.buildResponse("ok");
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param model 安装告知
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/updateInfo")
    @ApiOperation(httpMethod = "POST", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
    public ResponseModel<JgScrapCancelDto> updateInfo(@RequestParam String submitType, @RequestBody Map<String, Object> model, @RequestParam(value = "op", required = false) String op) {
        JgScrapCancelDto jgScrapCancelDto = BeanUtil.mapToBean(((LinkedHashMap) model.get("jgScrapCancelAdd")), JgScrapCancelDto.class, true);
        if (Objects.isNull(jgScrapCancelDto)) {
            throw new IllegalArgumentException("参数jgScrapCancelAdd不能为空");
        }
        Object o = ((LinkedHashMap<?, ?>) model.get("jgScrapCancelAdd")).get("cancelCertificateList");
        jgScrapCancelDto.setCancelCertificateList((List<Map<String, Object>>) o);
        return ResponseHelper.buildResponse(jgScrapCancelService.updateInfo(submitType, jgScrapCancelDto, op));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/flowExecute")
    @ApiOperation(httpMethod = "POST", value = "执行流程", notes = "执行流程")
    public ResponseModel<Object> flowExecute(@RequestBody JSONObject map) {

        LinkedHashMap model1 = (LinkedHashMap) map.get("model");
        LinkedHashMap jgScrapCancelInfo = (LinkedHashMap) model1.get("jgScrapCancelAdd");
        jgScrapCancelInfo.remove("SEQUENCE_NBR");
        JgScrapCancelDto jgScrapCancelDto = JSON.parseObject(JSON.toJSONString(jgScrapCancelInfo), JgScrapCancelDto.class);

        jgScrapCancelService.flowExecute(Long.valueOf(String.valueOf(jgScrapCancelDto.getSequenceNbr())), jgScrapCancelDto.getInstanceId(), String.valueOf(map.get("operate")), String.valueOf(map.get("opinion")));
        return ResponseHelper.buildResponse("ok");
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/deleteBatch")
    @ApiOperation(httpMethod = "POST", value = "批量删除", notes = "批量删除")
    public ResponseModel<Object> deleteBatch(@RequestBody JSONObject map) {
        List<Long> ids = (List<Long>) map.get("ids");
        jgScrapCancelService.deleteBatch(ids);
        return ResponseHelper.buildResponse("ok");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/deleteMessage")
    @ApiOperation(httpMethod = "POST", value = "单个删除", notes = "单个删除")
    public ResponseModel<Object> deleteMessage(@RequestParam("id") Long id) {
        List<Long> ids = Collections.singletonList(id);
        jgScrapCancelService.deleteBatch(ids);
        return ResponseHelper.buildResponse("ok");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "列表全部数据查询", notes = "列表全部数据查询")
    @PostMapping(value = "/getList")
    public ResponseModel<Page<Map<String, Object>>> getList(JgScrapCancelDto dto,
                                                            @RequestParam(value = "current") int current,
                                                            @RequestParam(value = "size") int size) {
        Page<Map<String, Object>> page = new Page<>(current, size);
        return ResponseHelper.buildResponse(jgScrapCancelService.getList(dto, page, dto.getRoleIds()));
    }


    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/details")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个详情", notes = "根据sequenceNbr查询单个详情")
    public ResponseModel<Map<String, Object>> selectOne(@RequestParam("sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(jgScrapCancelService.queryBySequenceNbr(sequenceNbr));
    }


    /**
     * 撤回
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/withdraw")
    @ApiOperation(httpMethod = "POST", value = "撤回", notes = "撤回")
    public ResponseModel<Object> revocation(@RequestBody JSONObject map) {
        jgScrapCancelService.revocation(String.valueOf(map.get("instanceId")));
        return ResponseHelper.buildResponse("ok");
    }


}
