package com.yeejoin.amos.boot.module.jg.biz.controller;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.common.biz.utils.CommonResponseUtil;
import com.yeejoin.amos.boot.module.jg.api.dto.JgTransferNoticeDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgTransferNotice;
import com.yeejoin.amos.boot.module.jg.api.service.IJgTransferNoticeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * 移装造告知
 *
 * @author system_generator
 * @date 2023-12-19
 */
@RestController
@Api(tags = "移装造告知Api")
@RequestMapping(value = "/jg-transfer-notice")
public class JgTransferNoticeController extends BaseController {

    @Autowired
    private IJgTransferNoticeService jgTransferNoticeService;

    /**
     * 新增移装造告知
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增移装造告知", notes = "新增移装造告知")
    public ResponseModel<String> save(@RequestParam String submitType, @RequestBody Map<String, JgTransferNoticeDto> model) {
        ReginParams reginParams = getSelectedOrgInfo();
        jgTransferNoticeService.saveNotice(submitType, model, reginParams);
        return ResponseHelper.buildResponse("");
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/update")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新移装造告知", notes = "根据sequenceNbr更新移装造告知")
    public ResponseModel<JgTransferNoticeDto> updateBySequenceNbrJgTransferNotice(
            @RequestParam String submitType,
            @RequestBody Map<String, Object> model,
            @RequestParam(value = "op", required = false) String op) {
        JgTransferNoticeDto transferNoticeInfo = BeanUtil.mapToBean(((LinkedHashMap) model.get("transferNoticeInfo")), JgTransferNoticeDto.class, true);
        if (Objects.isNull(transferNoticeInfo)) {
            throw new IllegalArgumentException("参数transferInfo不能为空");
        }
        Object o = ((LinkedHashMap<?, ?>) model.get("transferNoticeInfo")).get("proxyStatementAttachmentList");
        Object o1 = ((LinkedHashMap<?, ?>) model.get("transferNoticeInfo")).get("installContractAttachmentList");
        transferNoticeInfo.setConstructionContractList((List<Map<String, Object>>) o);
        transferNoticeInfo.setPowerOfAttorneyList((List<Map<String, Object>>) o1);
        return ResponseHelper.buildResponse(jgTransferNoticeService.updateTransferNotice(submitType, transferNoticeInfo, op));

    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/delete")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除移装造告知", notes = "根据sequenceNbr删除移装造告知")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @RequestParam(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(jgTransferNoticeService.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr批量删除
     *
     * @param sequenceNbrs 主键
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/batchDelete")
    @ApiOperation(value = "根据sequenceNbr删除维保合同备案", notes = "根据sequenceNbr删除维保合同备案")
    public ResponseModel<Boolean> deleteForBatch(@RequestParam("sequenceNbrs") Long[] sequenceNbrs) {
        try {
            return ResponseHelper.buildResponse(jgTransferNoticeService.deleteForBatch(sequenceNbrs));
        } catch (Exception e) {
            return CommonResponseUtil.failure(e.getMessage());
        }
    }


    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/details")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个移装造告知", notes = "根据sequenceNbr查询单个移装造告知")
    public ResponseModel<Map<String, Map<String, Object>>> selectOne(@RequestParam Long sequenceNbr) {
        return ResponseHelper.buildResponse(jgTransferNoticeService.queryBySequenceNbr(sequenceNbr));
    }


    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/page")
    @ApiOperation(httpMethod = "POST", value = "移装造告知分页查询", notes = "移装造告知分页查询")
    public ResponseModel<Page<JgTransferNoticeDto>> queryForPage(
            @ApiParam(value = "当前页码", required = true) @RequestParam(value = "current", defaultValue = "1") int current,
            @ApiParam(value = "每页大小", required = true) @RequestParam(value = "size", defaultValue = "20") int size,
            @ApiParam(value = "类型：enterprise-企业端、supervision-监管端", required = true) @RequestParam(value = "type", defaultValue = "enterprise") String type,
            @RequestBody(required = false) JgTransferNoticeDto model
    ) {
        Page<JgTransferNotice> page = new Page<>(current, size);
        ReginParams reginParams = getSelectedOrgInfo();
        return ResponseHelper.buildResponse(jgTransferNoticeService.queryForJgTransferNoticePage(page, model, type, reginParams));
    }

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "移装造告知列表全部数据查询", notes = "移装造告知列表全部数据查询")
    @GetMapping(value = "/generate-report")
    public ResponseModel<String> selectForList(@RequestParam("sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(jgTransferNoticeService.generateTransferNoticeReport(sequenceNbr));
    }
}
