package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jg.api.dto.JgUseRegistrationDto;
import com.yeejoin.amos.boot.module.jg.api.entity.*;
import com.yeejoin.amos.boot.module.jg.api.enums.EquipTypeEnum;
import com.yeejoin.amos.boot.module.jg.api.enums.UseStatusEnum;
import com.yeejoin.amos.boot.module.jg.api.mapper.*;
import com.yeejoin.amos.boot.module.jg.api.service.IJgChangeRegistrationReformService;
import com.yeejoin.amos.boot.module.jg.api.dto.JgChangeRegistrationReformDto;
import com.yeejoin.amos.boot.module.jg.biz.feign.TzsServiceFeignClient;
import com.yeejoin.amos.boot.module.jg.flc.api.fegin.WorkFlowFeignService;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgTechParamsElevator;
import com.yeejoin.amos.boot.module.ymt.api.entity.InspectionDetectionInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.OtherInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.UseInfo;
import com.yeejoin.amos.boot.module.ymt.api.enums.ApplicationFormTypeEnum;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import com.yeejoin.amos.boot.module.ymt.api.mapper.*;
import com.yeejoin.amos.boot.module.ymt.api.service.ICreateCodeService;
import com.yeejoin.amos.feign.workflow.Workflow;
import com.yeejoin.amos.feign.workflow.model.ActWorkflowStartDTO;
import com.yeejoin.amos.feign.workflow.model.AjaxResult;
import com.yeejoin.amos.feign.workflow.model.TaskResultDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 改造变更登记服务实现类
 *
 * @author system_generator
 * @date 2023-12-20
 */
@Service
public class JgChangeRegistrationReformServiceImpl extends BaseService<JgChangeRegistrationReformDto, JgChangeRegistrationReform, JgChangeRegistrationReformMapper> implements IJgChangeRegistrationReformService {
    @Autowired
    WorkFlowFeignService workFlowFeginService;

    @Autowired
    TzsServiceFeignClient tzsServiceFeignClient;
    @Autowired
    RedisUtils redisUtils;
    @Autowired
    private UseInfoMapper useInfoMapper;
    @Autowired
    private InspectionDetectionInfoMapper inspectionDetectionInfoMapper;
    @Autowired
    private OtherInfoMapper otherInfoMapper;
    //改造登记关系表mapper
    @Autowired
    private JgChangeRegistrationReformEqMapper jgChangeRegistrationReformEqMapper;
    //移装登记关系表
    @Autowired
    private JgChangeRegistrationTransferEqMapper jgChangeRegistrationTransferEqMapper;
    @Autowired
    private IdxBizJgTechParamsElevatorMapper idxBizJgTechParamsElevatorMapper;
    @Autowired
    private JgRegistrationHistoryMapper jgRegistrationHistoryMapper;
    //使用登记关系表mapper
    @Autowired
    private JgUseRegistrationEqMapper jgUseRegistrationEqMapper;
    @Autowired
    private IdxBizJgRegisterInfoMapper idxBizJgRegisterInfoMapper;
    @Autowired
    private ICreateCodeService iCreateCodeService;
    @Autowired
    private IdxBizJgOtherInfoMapper idxBizJgOtherInfoMapper;


    /**
     * 分页查询
     */
    public Page<Map<String, Object>> getList(JgChangeRegistrationReformDto dto, Page<Map<String, Object>> page, List<String> roleIds) {
        Page<Map<String, Object>> listPage = this.baseMapper.getListPage(page, dto, roleIds);
        return listPage;
    }

    public Page<Map<String, Object>> getEquipList(Page<Map<String, Object>> page, String factoryNum, String equList, String equCategory) {
        return this.baseMapper.getEquipListPage(page, factoryNum, equList, equCategory);
    }

    @Transactional
    public void save(JSONObject map) {
        UseInfo useInfo = new UseInfo();
        BeanUtil.copyProperties(map, useInfo);
        LambdaQueryWrapper<UseInfo> lambda = new QueryWrapper<UseInfo>().lambda();
        lambda.eq(UseInfo::getRecord, map.get("equipId"));
        // 更新使用信息
        useInfoMapper.update(useInfo, lambda);
        InspectionDetectionInfo inspectionDetectionInfo = new InspectionDetectionInfo();
        BeanUtil.copyProperties(map, inspectionDetectionInfo);
        LambdaQueryWrapper<InspectionDetectionInfo> inspectionLambda = new QueryWrapper<InspectionDetectionInfo>().lambda();
        inspectionLambda.eq(InspectionDetectionInfo::getRecord, map.get("equipId"));
        // 更新检验检测信息
        inspectionDetectionInfoMapper.update(inspectionDetectionInfo, inspectionLambda);
        // 使用登记信息
        JgChangeRegistrationReform jgChangeRegistrationReform = new JgChangeRegistrationReform();
        LambdaQueryWrapper<OtherInfo> otherLambda = new QueryWrapper<OtherInfo>().lambda();
        otherLambda.eq(OtherInfo::getRecord, map.get("equipId"));
        OtherInfo otherInfo = otherInfoMapper.selectOne(otherLambda);
        String supervisoryCode = otherInfo.getSupervisoryCode();
        jgChangeRegistrationReform.setSupervisoryCode(supervisoryCode);
        jgChangeRegistrationReform.setUseUnitName(useInfo.getUseUnitName());
        jgChangeRegistrationReform.setUseUnitCreditCode(useInfo.getUseUnitCreditCode());
        jgChangeRegistrationReform.setInspectUnitCreditCode(map.get("inspectUnitCreditCode").toString());
        jgChangeRegistrationReform.setInspectUnitName(map.get("inspectOrgName").toString());
        JgRegistrationHistory jgRegistrationHistory =new JgRegistrationHistory();
        //使用登记编号
        jgRegistrationHistory.setUseRegistrationCode(idxBizJgRegisterInfoMapper.getUseOrgCodeByEquip(map.get("equipId").toString()));
        //登记类别
        jgRegistrationHistory.setRegistrationClass("改造登记");
        //设备id
        jgRegistrationHistory.setEquId(map.get("equipId").toString());
        //修改数据
        jgRegistrationHistory.setChangeData(JSONObject.toJSONString(map));
        //设备监管码
        jgRegistrationHistory.setSupervisoryCode(supervisoryCode);
        //数据状态
        jgRegistrationHistory.setStatus("new");
        if (map.containsKey("type") && "edit".equals(String.valueOf(map.get("type")))) {
            jgChangeRegistrationReform.setUseUnitCreditCode(null);
            jgChangeRegistrationReform.setSequenceNbr(Long.valueOf(String.valueOf(map.get("sequenceNbr"))));
            this.getBaseMapper().updateById(jgChangeRegistrationReform);
            jgRegistrationHistory.setSequenceNbr(jgRegistrationHistoryMapper.getSequenceNbrByEquidAndDocumentId(map.get("equipId").toString(),String.valueOf(map.get("sequenceNbr"))));
            jgRegistrationHistoryMapper.updateById(jgRegistrationHistory);
        } else {

            // 业务管理设备信息保存
            JgChangeRegistrationReformEq jgChangeRegistrationReformEq = new JgChangeRegistrationReformEq();
            jgChangeRegistrationReformEq.setEquId(map.get("equipId").toString());
//            jgRelationEquip.setBusinessType(String.valueOf(BusinessTypeEnum.USAGE_REGISTRATION.getCode()));
            List<String> applicationFormCode = iCreateCodeService.createApplicationFormCode(ApplicationFormTypeEnum.GZBG.getCode(), 1);
            jgChangeRegistrationReform.setApplyNo(applicationFormCode.get(0));
            jgChangeRegistrationReform.setAuditStatus("待提交");
            jgChangeRegistrationReform.setStatus(FlowStatusEnum.TO_BE_SUBMITTED.getName());
            this.save(jgChangeRegistrationReform);
            jgChangeRegistrationReformEq.setEquipTransferId(jgChangeRegistrationReform.getSequenceNbr().toString());
            jgChangeRegistrationReformEqMapper.insert(jgChangeRegistrationReformEq);
            //当前单据id
            jgRegistrationHistory.setCurrentDocumentId(jgChangeRegistrationReform.getSequenceNbr().toString());
            jgRegistrationHistoryMapper.insert(jgRegistrationHistory);
        }

        if (!ObjectUtils.isEmpty(map.get("submit"))) {
            String instanceId = "";
            if (map.containsKey("instanceId")) {
                instanceId = map.get("instanceId").toString();
            } else {
                // 启动并执行流程
                instanceId = startByVariable();
                jgChangeRegistrationReform.setInstanceStatus("1460532889249755137");
                jgChangeRegistrationReform.setUseUnitCreditCode("91610131628001738N");
                jgChangeRegistrationReform.setReceiveCompanyCode("610000");
            }

            if (!ObjectUtils.isEmpty(instanceId)) {
                // 执行流程
                String status = flowExecute(jgChangeRegistrationReform.getSequenceNbr(), instanceId, "0", "", true);
                jgChangeRegistrationReform.setAuditStatus("已提交");
                jgChangeRegistrationReform.setStatus(FlowStatusEnum.TO_BE_PROCESSED.getName());
            }
            jgChangeRegistrationReform.setInstanceId(instanceId);

            this.getBaseMapper().updateById(jgChangeRegistrationReform);

        }
    }

    public String startByVariable() {
        String instanceId = "";
        //启动流程
        try {
            ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
            dto.setProcessDefinitionKey("renovationRegistrationReview");
            dto.setBusinessKey("submit");
            AjaxResult ajaxResult = Workflow.taskClient.startByVariable(dto);
            instanceId = ((Map) ajaxResult.get("data")).get("id").toString();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return instanceId;
    }

    public String flowExecute(Long id, String instanceId, String operate, String comment, Boolean update) {
        String role = "";
        String taskName = "流程结束";
        ArrayList<String> roleList = new ArrayList<>();
        try {
            JSONObject task = workFlowFeginService.getTaskNoAuth(instanceId);
            JSONObject taskMessage = JSON.parseObject(JSON.toJSONString(task.get("data")));
            String taskId = taskMessage.getString("id");
            //组装信息
            TaskResultDTO dto = new TaskResultDTO();
            dto.setResultCode("approvalStatus");
            dto.setTaskId(taskId);
            dto.setComment(comment);
            HashMap<String, Object> map = new HashMap<>();
            map.put("approvalStatus", operate);
            dto.setVariable(map);
            //执行流程
            Workflow.taskClient.completeByTask(taskId, dto);
            // 查询下节点任务
            JSONObject taskNoAuth = workFlowFeginService.getTaskNoAuth(instanceId);
            if (!ObjectUtils.isEmpty(taskNoAuth.get("data"))) {
                JSONObject nextTask = JSON.parseObject(JSON.toJSONString(taskNoAuth.get("data")));
                String nextTaskId = nextTask.getString("id");
                taskName = nextTask.getString("name");
                AjaxResult taskGroupName = Workflow.taskClient.getTaskGroupName(nextTaskId);
                JSONArray data = JSON.parseArray(JSON.toJSONString(taskGroupName.get("data")));
                for (Object datum : data) {
                    if (((Map) datum).containsKey("groupId")) {
                        roleList.add(((Map) datum).get("groupId").toString());
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        role = String.join(",", roleList);
        if (update) {
            Boolean rollBack = "1".equals(operate) ? true : false;
            updateStatus(id, instanceId, taskName, role, rollBack);
        }
        return role;
    }

    public void updateStatus(Long id, String instanceId, String taskName, String role, Boolean rollBack) {
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        LambdaQueryWrapper<JgChangeRegistrationReform> lambda = new QueryWrapper<JgChangeRegistrationReform>().lambda();
        lambda.eq(JgChangeRegistrationReform::getSequenceNbr, id);
        JgChangeRegistrationReform jgChangeRegistrationReform = this.getBaseMapper().selectOne(lambda);
        if ("流程结束".equals(taskName)) {
            JgChangeRegistrationReformEq jgChangeRegistrationReformEq = jgChangeRegistrationReformEqMapper.selectOne(new QueryWrapper<JgChangeRegistrationReformEq>().eq("equip_transfer_id", jgChangeRegistrationReform.getSequenceNbr()));
            jgChangeRegistrationReform.setStatus(taskName);
            jgChangeRegistrationReform.setAuditStatus(FlowStatusEnum.TO_BE_FINISHED.getName());

            //交换历史数据与新增数据
            updateTechparamsByEquIdAndCurrentDoucumentId(jgChangeRegistrationReformEq.getEquId(), jgChangeRegistrationReform.getSequenceNbr().toString(),jgChangeRegistrationReform.getSupervisoryCode());
        } else {
            jgChangeRegistrationReform.setNextExecutorIds(role);
            jgChangeRegistrationReform.setPromoter(reginParams.getUserModel().getUserId());
            if (!ObjectUtils.isEmpty(jgChangeRegistrationReform.getInstanceStatus())) {
                jgChangeRegistrationReform.setInstanceStatus(jgChangeRegistrationReform.getInstanceStatus() + "," + role);
            } else {
                jgChangeRegistrationReform.setInstanceStatus(role);
            }
            UseStatusEnum message = UseStatusEnum.getMessage(taskName);
            jgChangeRegistrationReform.setStatus(message.getPass());
        }
        if (rollBack) {
            this.getBaseMapper().update(jgChangeRegistrationReform, lambda);
            this.getBaseMapper().updatePromoter(jgChangeRegistrationReform.getSequenceNbr());
        } else {
            this.getBaseMapper().update(jgChangeRegistrationReform, lambda);
        }
    }

    public void withdraw(String instanceId) {
        String taskName = "";
        JgChangeRegistrationReform jgChangeRegistrationReform = new JgChangeRegistrationReform();
        LambdaQueryWrapper<JgChangeRegistrationReform> lambda = new QueryWrapper<JgChangeRegistrationReform>().lambda();
        lambda.eq(JgChangeRegistrationReform::getInstanceId, instanceId);
        ArrayList<String> roleList = new ArrayList<>();
        try {
            workFlowFeginService.rollBack(instanceId);
            JSONObject taskNoAuth = workFlowFeginService.getTaskNoAuth(instanceId);
            JSONObject nextTask = JSON.parseObject(JSON.toJSONString(taskNoAuth.get("data")));
            taskName = nextTask.getString("name");
            if (!ObjectUtils.isEmpty(taskNoAuth.get("data"))) {
                String nextTaskId = nextTask.getString("id");
                AjaxResult taskGroupName = Workflow.taskClient.getTaskGroupName(nextTaskId);
                JSONArray data = JSON.parseArray(JSON.toJSONString(taskGroupName.get("data")));
                for (Object datum : data) {
                    if (((Map) datum).containsKey("groupId")) {
                        roleList.add(((Map) datum).get("groupId").toString());
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (!ObjectUtils.isEmpty(taskName)) {
            UseStatusEnum message = UseStatusEnum.getMessage(taskName);
            jgChangeRegistrationReform.setStatus(message.getPass());
        }

        String join = String.join(",", roleList);
        JgChangeRegistrationReform jgChangeRegistrationReform1 = this.getBaseMapper().selectOne(lambda);
        this.updateStatus(jgChangeRegistrationReform1.getSequenceNbr(), instanceId, taskName, join, true);
    }

    public void deleteBatch(List<Long> ids) {
        JgChangeRegistrationReform jgChangeRegistrationReform = new JgChangeRegistrationReform();
        jgChangeRegistrationReform.setIsDelete(true);
        LambdaQueryWrapper<JgChangeRegistrationReform> lambda = new QueryWrapper<JgChangeRegistrationReform>().lambda();
        lambda.in(JgChangeRegistrationReform::getSequenceNbr, ids);
        this.update(jgChangeRegistrationReform, lambda);
        JgChangeRegistrationReformEq jgChangeRegistrationReformEq = new JgChangeRegistrationReformEq();
        jgChangeRegistrationReformEq.setIsDelete(true);
        LambdaQueryWrapper<JgChangeRegistrationReformEq> lambda1 = new QueryWrapper<JgChangeRegistrationReformEq>().lambda();
        lambda1.in(JgChangeRegistrationReformEq::getEquipTransferId, ids);
        jgChangeRegistrationReformEqMapper.update(jgChangeRegistrationReformEq, lambda1);
    }

    public Map<String, Object> getDetail(String id) {
        Map<String, Object> detail = this.baseMapper.getDetail(id);
        Map<String, Object> inspectDetail = this.baseMapper.getInspectDetail(id);
        Map<String, Object> useDetail = this.baseMapper.getUseDetail(id);
        if(detail.get("status").equals("已完成")){

        }else {

        }
        detail.putAll(inspectDetail);
        detail.putAll(useDetail);
        detail.putAll(useDetail);
        detail.put("proDuctPhoto", JSON.parse(String.valueOf(detail.get("proDuctPhoto"))));
        detail.put("factoryStandard", JSON.parse(String.valueOf(detail.get("factoryStandard"))));
        detail.put("productQualityYieldProve", JSON.parse(String.valueOf(detail.get("productQualityYieldProve"))));
        detail.put("insUseMaintainExplanin", JSON.parse(String.valueOf(detail.get("insUseMaintainExplanin"))));
        detail.put("inspectReport", JSON.parse(String.valueOf(detail.get("inspectReport"))));
        return detail;
    }


    /**
     * 批量设置设备无效(使用登记、移装登记、改造登记)
     *
     * @param equipmentId       装备id
     * @param currentDocumentId 当前文档id
     */
    public void makeEquipmentsInvalid(String equipmentId, String currentDocumentId) {
        jgChangeRegistrationReformEqMapper.updateEquipIsVaildByEquipIdAndCurrentDocumentId(equipmentId, currentDocumentId);
        jgChangeRegistrationTransferEqMapper.updateEquipIsVaildByEquipIdAndCurrentDocumentId(equipmentId, currentDocumentId);
        jgUseRegistrationEqMapper.updateEquipIsVaildByEquipIdAndCurrentDocumentId(equipmentId, currentDocumentId);
    }

    /**
     * 流程完成之后互换数据并更新设备状态
     * @param equipId
     * @param currentDocumentId
     */
    public void updateTechparamsByEquIdAndCurrentDoucumentId(String equipId, String currentDocumentId,String supervisoryCode){
        String newUseRegistrationCertificateNumber=getCode(supervisoryCode);
        IdxBizJgTechParamsElevator idxBizJgTechParamsElevator =idxBizJgTechParamsElevatorMapper.selectOne(new QueryWrapper<IdxBizJgTechParamsElevator>().eq("RECORD",equipId));
        JgRegistrationHistory jgRegistrationHistory=jgRegistrationHistoryMapper.selectOne(new QueryWrapper<JgRegistrationHistory>()
                .eq("equ_id",equipId)
                .eq("current_document_id",currentDocumentId)
                .eq("registration_class","改造登记"));

        if(!ObjectUtils.isEmpty(idxBizJgTechParamsElevator)&&!ObjectUtils.isEmpty(jgRegistrationHistory)){
            //历史数据
            String historyData = JSONObject.toJSONString(idxBizJgTechParamsElevator);
            //当前数据
            String newData = jgRegistrationHistory.getChangeData();
            //将历史数据更新到技术参数表中
            IdxBizJgTechParamsElevator idxBizJgTechParamsElevatorNew = JSONObject.parseObject(newData,IdxBizJgTechParamsElevator.class);
            BeanUtil.copyProperties(idxBizJgTechParamsElevatorNew,idxBizJgTechParamsElevator, "sequenceNbr","record");
            idxBizJgTechParamsElevatorMapper.updateById(idxBizJgTechParamsElevator);
            //将历史数据回填到历史记录表中
            jgRegistrationHistory.setChangeData(historyData);
            jgRegistrationHistory.setStatus("history");
            jgRegistrationHistoryMapper.updateById(jgRegistrationHistory);
            makeEquipmentsInvalid(equipId,currentDocumentId);
            //更新使用注册登记证编号
            idxBizJgRegisterInfoMapper.updateUseOrgCodeByEquip(equipId,newUseRegistrationCertificateNumber);
            //es中的编号信息
            Map<String,Map<String,Object>> resultMap = new HashMap<>();
            Map<String,Object> map1 =new HashMap<>();
            map1.put("USE_ORG_CODE",newUseRegistrationCertificateNumber );
            resultMap.put(equipId,map1);
            tzsServiceFeignClient.commonUpdateEsDataByIds(resultMap);
        }
    }
    /*
    * 获取电梯的原始技术参数
    * @param equipId
     */
    public Map<String,Object> getOriginalTechParams(String equipId){
        Map<String,Object> result = new HashMap<>();
        IdxBizJgTechParamsElevator idxBizJgTechParamsElevator =idxBizJgTechParamsElevatorMapper.selectOne(new QueryWrapper<IdxBizJgTechParamsElevator>().eq("RECORD",equipId));
        if(!ObjectUtils.isEmpty(idxBizJgTechParamsElevator)){
            result = JSONObject.parseObject(JSONObject.toJSONString(idxBizJgTechParamsElevator),Map.class);
            result.remove("sequenceNbr");
        }
        return  result;
    }
    /**
     * 参数为监管码
     * @param supervisoryCode
     * @return
     */
    public String getCode(String supervisoryCode) {
        if (!ObjectUtils.isEmpty(supervisoryCode) && supervisoryCode.length() > 5) {
            String name = EquipTypeEnum.getMessage(supervisoryCode.substring(1, 2));
            String type = supervisoryCode.substring(2, 4);
            String city = supervisoryCode.substring(0, 1);
            ResponseModel<String> stringResponseModel = tzsServiceFeignClient.useRegistrationCode(name + type + "陕" + city);
            return stringResponseModel.getResult();
        }
        return null;
    }
}