package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.CompanyBo;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.entity.DataDictionary;
import com.yeejoin.amos.boot.biz.common.service.impl.DataDictionaryServiceImpl;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jg.api.dto.JgMaintenanceContractDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgMaintenanceContract;
import com.yeejoin.amos.boot.module.jg.api.entity.JgMaintenanceContractEq;
import com.yeejoin.amos.boot.module.jg.api.entity.JgUseRegistration;
import com.yeejoin.amos.boot.module.jg.api.enums.*;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgMaintenanceContractEqMapper;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgMaintenanceContractMapper;
import com.yeejoin.amos.boot.module.jg.api.service.IJgMaintenanceContractService;
import com.yeejoin.amos.boot.module.jg.api.vo.EquipMessageVo;
import com.yeejoin.amos.boot.module.jg.api.vo.JgMaintenanceContractVo;
import com.yeejoin.amos.boot.module.jg.flc.api.fegin.WorkFlowFeignService;
import com.yeejoin.amos.boot.module.ymt.api.enums.ApplicationFormTypeEnum;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import com.yeejoin.amos.boot.module.ymt.api.service.ICreateCodeService;
import com.yeejoin.amos.feign.workflow.Workflow;
import com.yeejoin.amos.feign.workflow.model.ActWorkflowStartDTO;
import com.yeejoin.amos.feign.workflow.model.AjaxResult;
import com.yeejoin.amos.feign.workflow.model.TaskResultDTO;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2023-12-12
 */
@Service
public class JgMaintenanceContractServiceImpl extends BaseService<JgMaintenanceContractDto, JgMaintenanceContract, JgMaintenanceContractMapper> implements IJgMaintenanceContractService {

    public static final String SUBMIT_TYPE_FLOW = "1";
    public static final String WB_PROCESS_DEFINITION_KEY = "maintenanceFiling";
    private static final String HANDLING_STATUS_DICTIONARY = "JGGZZZ";
    @Autowired
    RestHighLevelClient restHighLevelClient;
    @Autowired
    WorkFlowFeignService workFlowFeginService;
    @Autowired
    @SuppressWarnings("all")
    private ICreateCodeService iCreateCodeService;
    @Autowired
    private JgMaintenanceContractMapper maintenanceContractMapper;
    @Autowired
    private JgMaintenanceContractEqMapper maintenanceContractEqMapper;
    @Autowired
    private JgMaintenanceContractEqServiceImpl jgMaintenanceContractEqService;
    @Autowired
    private DataDictionaryServiceImpl iDataDictionaryService;
    @Autowired
    RedisUtils redisUtils;

    /**
     * 分页查询
     */
    public Page<JgMaintenanceContractVo> queryForPage(Page<JgMaintenanceContract> page,
                                                      int phase,
                                                      JgMaintenanceContractDto dto,
                                                      ReginParams reginParams) {
        Page<JgMaintenanceContractDto> contractList = new Page<>();
        Page<JgMaintenanceContractVo> result = new Page<>();
        CompanyBo company = reginParams.getCompany();
        if (MaintenanceEnum.SHIYONG.getCode().equals(phase)) {
            //使用单位用"使用单位统一信用代码"匹配数据
            dto.setUseUnitCode(company.getCompanyCode());
            dto.setRoleIds(null);
            contractList = maintenanceContractMapper.getContractList(page, dto);
        } else if (MaintenanceEnum.WEIBAO.getCode().equals(phase)) {
            //维保单位用"维保单位统一信用代码"匹配数据
            dto.setMaintenanceUnitCode(company.getCompanyCode());
            contractList = maintenanceContractMapper.getContractList(page, dto);
        } else if (MaintenanceEnum.JIANGUAN.getCode().equals(phase)) {
            //监管单位用"接收机构统一使用代码"匹配
            dto.setReceiveOrgCode(company.getCompanyCode());
            contractList = maintenanceContractMapper.getContractList(page, dto);
        }
        BeanUtils.copyProperties(contractList, result);
        return result;
    }

    /**
     * 根据sequenceNbr查询数据
     */
    public JgMaintenanceContractVo queryBySequenceNbr(Long sequenceNbr) {
        JgMaintenanceContractDto dto = maintenanceContractMapper.queryBySequenceNbr(sequenceNbr);
        JgMaintenanceContractVo vo = new JgMaintenanceContractVo();
        BeanUtils.copyProperties(dto, vo);
        vo.setMaintenanceContract(ObjectUtils.isEmpty(dto.getMaintenanceContract()) ? null : JSON.parseArray(dto.getMaintenanceContract()));
        List<Map<String, Object>> list = maintenanceContractMapper.selectEquipList(sequenceNbr);
        if (!ObjectUtils.isEmpty(list)){
            vo.setEquipmentLists(list);
        }
        return vo;
    }

    /**
     * 根据sequenceNbr更新数据
     *
     * @param dto
     * @return
     */
    public Boolean updateBySequenceNbr(JgMaintenanceContractDto dto) {
        return maintenanceContractMapper.updateBySequenceNbr(dto);
    }

    public void flowExecute(Long id,String instanceId, String operate, String comment, Boolean update) {
        try {
            JSONObject task = workFlowFeginService.getTaskNoAuth(instanceId);
            JSONObject taskMessage = JSON.parseObject(JSON.toJSONString(task.get("data")));
            String taskId = taskMessage.getString("id");
            //组装信息
            TaskResultDTO dto = new TaskResultDTO();
            dto.setResultCode("approvalStatus");
            dto.setTaskId(taskId);
            dto.setComment(comment);
            HashMap<String, Object> map = new HashMap<>();
            map.put("approvalStatus", operate);
            dto.setVariable(map);
            //执行流程
            Workflow.taskClient.completeByTask(taskId, dto);
        } catch (Exception e) {
            e.printStackTrace();
        }
        // 更新下一步执行人
        updateExecuteIds(instanceId, id, operate);

    }

    public void updateStatus(Long id , String taskName, String role, Boolean rollBack) {
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        LambdaQueryWrapper<JgMaintenanceContract> lambda = new QueryWrapper<JgMaintenanceContract>().lambda();
        lambda.eq(JgMaintenanceContract::getSequenceNbr, id);
        JgMaintenanceContract jgMaintenanceContract = this.getBaseMapper().selectOne(lambda);
        if ("流程结束".equals(taskName)) {
            jgMaintenanceContract.setStatus(taskName);
            jgMaintenanceContract.setApplyStatus("已完成");
        } else {
            jgMaintenanceContract.setNextExecuteIds(role);
            jgMaintenanceContract.setPromoter(reginParams.getUserModel().getUserId());
            if (!ObjectUtils.isEmpty(jgMaintenanceContract.getInstanceStatus())) {
                jgMaintenanceContract.setInstanceStatus(jgMaintenanceContract.getInstanceStatus() + "," + role);
            } else {
                jgMaintenanceContract.setInstanceStatus(role);
            }
            UseStatusEnum message = UseStatusEnum.getMessage(taskName);
            jgMaintenanceContract.setStatus(message.getPass());
        }
        if (rollBack){
            this.getBaseMapper().update(jgMaintenanceContract, lambda);
            this.getBaseMapper().updatePromoter(jgMaintenanceContract.getSequenceNbr());
        }else {
            this.getBaseMapper().update(jgMaintenanceContract, lambda);
        }
    }

    /**
     * 批量删除
     */
    @Transactional
    public Boolean deleteForBatch(Long[] ids) {
        List<Long> list = Arrays.asList(ids);
        list.forEach(x->{
            QueryWrapper<JgMaintenanceContract> wrapper = new QueryWrapper<>();
            wrapper.eq("sequence_nbr", x);
            JgMaintenanceContract jgMaintenanceContract = maintenanceContractMapper.selectOne(wrapper);
            LambdaQueryWrapper<JgMaintenanceContractEq> queryWrapper = new LambdaQueryWrapper<JgMaintenanceContractEq>()
                    .eq(JgMaintenanceContractEq::getEquipTransferId,jgMaintenanceContract.getApplyNo())
                    .eq(JgMaintenanceContractEq::getIsDelete, false);
            List<Long> listSeq = jgMaintenanceContractEqService.list(queryWrapper).stream()
                    .map(JgMaintenanceContractEq::getSequenceNbr).collect(Collectors.toList());
            maintenanceContractEqMapper.deleteForBatch(listSeq);
        });
        maintenanceContractMapper.deleteForBatch(list);
        return true;
    }

    public String startByVariable() {
        String instanceId = "";
        //启动流程
        try {
            ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
            dto.setProcessDefinitionKey(WB_PROCESS_DEFINITION_KEY);
            dto.setBusinessKey("submit");
            AjaxResult ajaxResult = Workflow.taskClient.startByVariable(dto);
            instanceId = ((Map<?, ?>) ajaxResult.get("data")).get("id").toString();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return instanceId;
    }

    /**
     * 维保合同提交
     */
    @Transactional
    public Boolean submit(JgMaintenanceContractDto dto,String comment,String operate) {
        String instanceId = "";
        try {
            AjaxResult ajaxResult;
            ActWorkflowStartDTO flowDto = new ActWorkflowStartDTO();
            flowDto.setProcessDefinitionKey(WB_PROCESS_DEFINITION_KEY);
            flowDto.setBusinessKey("1");
            ajaxResult = Workflow.taskClient.startByVariable(flowDto);
            instanceId = ((Map<?, ?>) ajaxResult.get("data")).get("id").toString();
            ajaxResult = Workflow.taskClient.getTask(instanceId);
            // 执行一步
            JSONObject dataObject = JSON.parseObject(JSON.toJSONString(ajaxResult.get("data")));
            String taskId = dataObject.getString("id");
            //组装信息
            TaskResultDTO taskResultDTO = new TaskResultDTO();
            taskResultDTO.setResultCode("approvalStatus");
            taskResultDTO.setTaskId(taskId);
            taskResultDTO.setComment(comment);
            HashMap<String, Object> map = new HashMap<>();
            map.put("approvalStatus", operate);
            taskResultDTO.setVariable(map);
            //执行流程
            Workflow.taskClient.completeByTask(taskId, taskResultDTO);
            Workflow.taskClient.completeByTask(taskId, taskResultDTO);
        } catch (Exception e) {
            e.printStackTrace();
        }

        dto.setApplyStatus(FlowStatusEnum.TO_BE_PROCESSED.getName());
        dto.setInstanceId(instanceId);
        dto.setReceiveOrgCode(null);
        return this.updateBySequenceNbr(dto);
    }

    @Transactional
    public Boolean approval(JgMaintenanceContractDto dto,String comment,String operate) {
        String instanceId = dto.getInstanceId();
        try {
            AjaxResult ajaxResult;
            ajaxResult = Workflow.taskClient.getTask(instanceId);
            JSONObject dataObject = JSON.parseObject(JSON.toJSONString(ajaxResult.get("data")));
            String taskId = dataObject.getString("id");
            //组装信息
            TaskResultDTO taskResultDTO = new TaskResultDTO();
            taskResultDTO.setResultCode("approvalStatus");
            taskResultDTO.setTaskId(taskId);
            taskResultDTO.setComment(comment);
            HashMap<String, Object> map = new HashMap<>();
            map.put("approvalStatus", operate);
            taskResultDTO.setVariable(map);
            //执行流程
            Workflow.taskClient.completeByTask(taskId, taskResultDTO);
        } catch (Exception e) {
            e.printStackTrace();
        }

//        if("tongguo"){
//            if("weibao"){
//                dto.setApplyStatus(FlowStatusEnum.TO_BE_PROCESSED.getName());
//            }else {
//                dto.setApplyStatus(FlowStatusEnum.TO_BE_PROCESSED.getName());
//            }
//        }else {
//            if("weibao"){
//                dto.setApplyStatus(FlowStatusEnum.TO_BE_PROCESSED.getName());
//            }else {
//                dto.setApplyStatus(FlowStatusEnum.TO_BE_PROCESSED.getName());
//            }
//        }



        if ("1".equals(operate)){

        }
        //审批通过
        if ("0".equals(operate)){

        }
        dto.setApplyStatus(FlowStatusEnum.TO_BE_PROCESSED.getName());
        dto.setInstanceId(instanceId);
        dto.setReceiveOrgCode(null);
        return this.updateBySequenceNbr(dto);
    }

    /**
     * 维保合同撤回
     */
    @Transactional
    public void revocation(String instanceId) {
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        String taskName = "";
        JgMaintenanceContract jgMaintenanceContract = new JgMaintenanceContract();
        LambdaQueryWrapper<JgMaintenanceContract> lambda = new QueryWrapper<JgMaintenanceContract>().lambda();
        lambda.eq(JgMaintenanceContract::getInstanceId, instanceId);
        ArrayList<String> roleList = new ArrayList<>();
        try {
            workFlowFeginService.rollBack(instanceId);
            JSONObject taskNoAuth = workFlowFeginService.getTaskNoAuth(instanceId);
            JSONObject nextTask = JSON.parseObject(JSON.toJSONString(taskNoAuth.get("data")));
            taskName = nextTask.getString("name");
            if (!ObjectUtils.isEmpty(taskNoAuth.get("data"))) {
                String nextTaskId = nextTask.getString("id");
                AjaxResult taskGroupName = Workflow.taskClient.getTaskGroupName(nextTaskId);
                JSONArray data = JSON.parseArray(JSON.toJSONString(taskGroupName.get("data")));
                for (Object datum : data) {
                    if (((Map<?, ?>) datum).containsKey("groupId")) {
                        roleList.add(((Map<?, ?>) datum).get("groupId").toString());
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (!ObjectUtils.isEmpty(taskName)) {

            jgMaintenanceContract.setStatus(MaintenceStatusEnum.getMessage(taskName).getRollBack());
        }
        String join = String.join(",", roleList);
        jgMaintenanceContract.setPromoter(reginParams.getUserModel().getUserId());
        jgMaintenanceContract.setNextExecuteIds(join);
        this.update(jgMaintenanceContract, lambda);
    }

    /**
     * 新增维保合同
     */
    @Transactional
    public Boolean saveOrSubmit(String submit, Map<String, Object> map, ReginParams reginParams) {
        JgMaintenanceContractDto dto = JSON.parseObject(JSON.toJSONString(map), JgMaintenanceContractDto.class);
        List<Map<String, Object>> equipmentLists = (List<Map<String, Object>>) map.get("equipmentLists");
        CompanyBo company = reginParams.getCompany();
        JgMaintenanceContract contract = new JgMaintenanceContract();
        BeanUtils.copyProperties(dto, contract);
        //获取维保备案编号
        String wbApplyNo = iCreateCodeService.createApplicationFormCode(ApplicationFormTypeEnum.WBBA.getCode(), 1).get(0);
        contract.setApplyNo(wbApplyNo);
        contract.setUseUnitCode(company.getCompanyCode());
        contract.setUseUnitName(company.getCompanyName());
        //管理员信息
        String[] MaintenanceManager = dto.getMaintenanceManagerId().split("_");
        contract.setMaintenanceManagerId(MaintenanceManager[0]);
        contract.setMaintenanceManagerName(MaintenanceManager[1]);
        //接收机构信息
        String[] splitReceiveOrgCode = dto.getReceiveOrgCode().split("_");
        contract.setReceiveOrgCode(splitReceiveOrgCode[0]);
        contract.setReceiveOrgName(splitReceiveOrgCode[1]);
        //维保单位信息
        String[] splitMaintenanceUnitCode = dto.getMaintenanceUnitCode().split("_");
        contract.setMaintenanceUnitCode(splitMaintenanceUnitCode[0]);
        contract.setMaintenanceUnitName(splitMaintenanceUnitCode[1]);

        contract.setApplyStatus(FlowStatusEnum.TO_BE_SUBMITTED.getName());
        contract.setEquNum(equipmentLists.size());

        // 新增编辑
        if ("add".equals(String.valueOf(map.get("pageType")))) {
            this.save(contract);
        } else {
            this.getBaseMapper().updateById(contract);
            LambdaQueryWrapper<JgMaintenanceContractEq> lambda = new QueryWrapper<JgMaintenanceContractEq>().lambda();
            lambda.eq(JgMaintenanceContractEq::getEquipTransferId, contract.getSequenceNbr());
            jgMaintenanceContractEqService.getBaseMapper().delete(lambda);
        }

        //关联设备信息
        List<JgMaintenanceContractEq> equipList = new ArrayList<>();
        equipmentLists.forEach(x -> {
            JgMaintenanceContractEq equip = new JgMaintenanceContractEq();
            equip.setEquId(String.valueOf(x.get("SEQUENCE_NBR")));
            equip.setEquipTransferId(contract.getSequenceNbr().toString());
            equipList.add(equip);
        });
        // 保存维保关联设备信息
        jgMaintenanceContractEqService.saveBatch(equipList);

        if (SUBMIT_TYPE_FLOW.equals(submit)) {
            String instanceId = null;
            // 提交启动流程
            if (map.containsKey("instanceId") && !ObjectUtils.isEmpty(map.get("instanceId"))) {
                instanceId = String.valueOf(map.get("instanceId"));
            } else {
                instanceId = startByVariable();
            }
            if (!ObjectUtils.isEmpty(instanceId)) {
                // 修改数据信息
                updateExecuteIds(instanceId, contract.getSequenceNbr(), "0");
                // 默认执行流程
                flowExecute(contract.getSequenceNbr(), instanceId, "0", "", false);
            }
        }
        return true;
    }

    public void updateExecuteIds(String instanceId, Long sequenceNbr, String operate){
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        String role = "";
        String taskName = "流程结束";
        ArrayList<String> roleList = new ArrayList<>();
        JgMaintenanceContract jgMaintenanceContract = this.getBaseMapper().selectById(sequenceNbr);
        try {
            // 查询下节点任务
            JSONObject taskNoAuth = workFlowFeginService.getTaskNoAuth(instanceId);
            if (!ObjectUtils.isEmpty(taskNoAuth.get("data"))) {
                JSONObject nextTask = JSON.parseObject(JSON.toJSONString(taskNoAuth.get("data")));
                String nextTaskId = nextTask.getString("id");
                taskName = nextTask.getString("name");
                AjaxResult taskGroupName = Workflow.taskClient.getTaskGroupName(nextTaskId);
                JSONArray data = JSON.parseArray(JSON.toJSONString(taskGroupName.get("data")));
                for (Object datum : data) {
                    if (((Map) datum).containsKey("groupId")) {
                        roleList.add(((Map) datum).get("groupId").toString());
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (!"流程结束".equals(taskName)){
            role= String.join(",", roleList);
            jgMaintenanceContract.setNextExecuteIds(role);
            jgMaintenanceContract.setPromoter(reginParams.getUserModel().getUserId());
            jgMaintenanceContract.setInstanceId(instanceId);
            if (!ObjectUtils.isEmpty(jgMaintenanceContract.getInstanceStatus())) {
                jgMaintenanceContract.setInstanceStatus(jgMaintenanceContract.getInstanceStatus() + "," + role);
            } else {
                jgMaintenanceContract.setInstanceStatus(role);
            }
            if ("0".equals(operate)){
                // 通过操作
                jgMaintenanceContract.setStatus(MaintenceStatusEnum.getMessage(taskName).getPass());
            }else {
                // 驳回操作
                jgMaintenanceContract.setStatus(MaintenceStatusEnum.getMessage(taskName).getReject());
                jgMaintenanceContract.setPromoter(null);
            }

        }else {
            jgMaintenanceContract.setStatus(taskName);
        }
        this.getBaseMapper().updateById(jgMaintenanceContract);

    }
    private void extracted(String instanceId, ArrayList<String> roleList, JgMaintenanceContract contract) {
        JSONObject taskNoAuth = workFlowFeginService.getTaskNoAuth(instanceId);
        if (!ObjectUtils.isEmpty(taskNoAuth.get("data"))) {
            JSONObject nextTask = JSON.parseObject(JSON.toJSONString(taskNoAuth.get("data")));
            String nextTaskId = nextTask.getString("id");
            AjaxResult taskGroupName = Workflow.taskClient.getTaskGroupName(nextTaskId);
            JSONArray data = JSON.parseArray(JSON.toJSONString(taskGroupName.get("data")));
            for (Object datum : data) {
                if (((Map<?, ?>) datum).containsKey("groupId")) {
                    roleList.add(((Map<?, ?>) datum).get("groupId").toString());
                }
            }
        }
        contract.setInstanceStatus(String.join(",", roleList));
    }

    /**
     * 更新维保合同和设备对应关系
     */
    @Transactional
    public Boolean updateMaintenanceAndEquipment(String submit,JgMaintenanceContractDto dto, List<Map<String, Object>> list) {
        String instanceId = null;

        //更新维保合同表
        String[] MaintenanceManager = dto.getMaintenanceManagerId().split("_");
        dto.setMaintenanceManagerId(dto.getMaintenanceManagerId());
        dto.setMaintenanceManagerName(MaintenanceManager[1]);

        String[] splitReceiveOrgCode = dto.getReceiveOrgCode().split("_");
        dto.setReceiveOrgCode(splitReceiveOrgCode[0]);
        dto.setReceiveOrgName(splitReceiveOrgCode[1]);

        String[] splitMaintenanceUnitCode = dto.getMaintenanceUnitCode().split("_");
        dto.setMaintenanceUnitCode(dto.getMaintenanceUnitCode());
        dto.setMaintenanceUnitName(splitMaintenanceUnitCode[1]);
        // 判断当前是否为提交
        if (SUBMIT_TYPE_FLOW.equals(submit)) {
            // 发起流程
            try {
                ActWorkflowStartDTO flowDto = new ActWorkflowStartDTO();
                flowDto.setProcessDefinitionKey(WB_PROCESS_DEFINITION_KEY);
                flowDto.setBusinessKey("1");
                AjaxResult ajaxResult = Workflow.taskClient.startByVariable(flowDto);
                instanceId = ((Map<?, ?>) ajaxResult.get("data")).get("id").toString();
                ajaxResult = Workflow.taskClient.getTask(instanceId);
                // 执行一步
                JSONObject dataObject = JSON.parseObject(JSON.toJSONString(ajaxResult.get("data")));
                String taskId = dataObject.getString("id");
                TaskResultDTO taskResultDTO = new TaskResultDTO();
                taskResultDTO.setResultCode("approvalStatus");
                taskResultDTO.setTaskId(taskId);
                taskResultDTO.setComment("提交流程");
                HashMap<String, Object> hashMap = new HashMap<>();
                hashMap.put("approvalStatus", "0");
                taskResultDTO.setVariable(hashMap);
                //执行流程
                Workflow.taskClient.completeByTask(taskId, taskResultDTO);
//                dto.setApplyFlow(MaintenanceEnum.SHIYONG.getMsg()+","+MaintenanceEnum.WEIBAO.getMsg());
                dto.setInstanceId(instanceId);
            } catch (Exception e) {
                log.error("维保使用单位提交流程启动失败：{}", e);
            }
        }
        this.updateBySequenceNbr(dto);
        //更新对应设备表
        if (!list.isEmpty()) {
            //先删除原先设备对应关系
            LambdaQueryWrapper<JgMaintenanceContractEq> queryWrapper = new LambdaQueryWrapper<JgMaintenanceContractEq>()
                    .eq(JgMaintenanceContractEq::getEquId,list.get(0).get("SEQUENCE_NBR"))
                    .eq(JgMaintenanceContractEq::getIsDelete, false);
            List<Long> listSeq = jgMaintenanceContractEqService.list(queryWrapper).stream()
                    .map(JgMaintenanceContractEq::getSequenceNbr).collect(Collectors.toList());
            jgMaintenanceContractEqService.deleteBatchSeq(listSeq);
            //重新生成关系表
            List<JgMaintenanceContractEq> equipList = new ArrayList<>();
            list.forEach(x -> {
                JgMaintenanceContractEq equip = new JgMaintenanceContractEq();
                equip.setEquId(String.valueOf(x.get("SEQUENCE_NBR")));
                equip.setEquipTransferId(dto.getApplyNo());
                equipList.add(equip);
            });
            return jgMaintenanceContractEqService.saveBatch(equipList);
        }
        return true;
    }
}