package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jg.api.dto.JgUseRegistrationDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgUseRegistration;
import com.yeejoin.amos.boot.module.jg.api.entity.JgUseRegistrationEq;
import com.yeejoin.amos.boot.module.jg.api.enums.EquipTypeEnum;
import com.yeejoin.amos.boot.module.jg.api.enums.UseStatusEnum;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgUseRegistrationEqMapper;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgUseRegistrationMapper;
import com.yeejoin.amos.boot.module.jg.api.service.IJgUseRegistrationService;
import com.yeejoin.amos.boot.module.jg.biz.feign.TzsServiceFeignClient;
import com.yeejoin.amos.boot.module.jg.flc.api.fegin.WorkFlowFeignService;
import com.yeejoin.amos.boot.module.ymt.api.entity.InspectionDetectionInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.OtherInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.UseInfo;
import com.yeejoin.amos.boot.module.ymt.api.enums.ApplicationFormTypeEnum;
import com.yeejoin.amos.boot.module.ymt.api.mapper.InspectionDetectionInfoMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.OtherInfoMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.UseInfoMapper;
import com.yeejoin.amos.boot.module.ymt.api.service.ICreateCodeService;
import com.yeejoin.amos.feign.workflow.Workflow;
import com.yeejoin.amos.feign.workflow.model.ActWorkflowStartDTO;
import com.yeejoin.amos.feign.workflow.model.AjaxResult;
import com.yeejoin.amos.feign.workflow.model.TaskResultDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2023-12-12
 */
@Service
public class JgUseRegistrationServiceImpl extends BaseService<JgUseRegistrationDto, JgUseRegistration, JgUseRegistrationMapper> implements IJgUseRegistrationService {

    @Autowired
    private UseInfoMapper useInfoMapper;
    @Autowired
    private InspectionDetectionInfoMapper inspectionDetectionInfoMapper;
    @Autowired
    private OtherInfoMapper otherInfoMapper;
    @Autowired
    private JgUseRegistrationEqMapper jgRelationEquipMapper;
    @Autowired
    WorkFlowFeignService workFlowFeginService;
    @Autowired
    private ICreateCodeService iCreateCodeService;
    @Autowired
    RedisUtils redisUtils;
    @Autowired
    TzsServiceFeignClient tzsServiceFeignClient;
    public Page<Map<String, Object>> getList(JgUseRegistrationDto dto, Page<Map<String, Object>> page ,List<String> roleIds) {
        Page<Map<String, Object>> listPage = this.baseMapper.getListPage(page, dto, roleIds);
        return listPage;
    }

    public Page<Map<String, Object>> getEquipList(Page<Map<String, Object>> page, String factoryNum, String equList, String equCategory) {
        return this.baseMapper.getEquipListPage(page, factoryNum, equList, equCategory);
    }


    @Transactional
    public void save(JSONObject map) {
        UseInfo useInfo = new UseInfo();
        BeanUtil.copyProperties(map, useInfo);
        LambdaQueryWrapper<UseInfo> lambda = new QueryWrapper<UseInfo>().lambda();
        lambda.eq(UseInfo::getRecord, map.get("equipId"));
        // 更新使用信息
        useInfoMapper.update(useInfo, lambda);
        InspectionDetectionInfo inspectionDetectionInfo = new InspectionDetectionInfo();
        BeanUtil.copyProperties(map, inspectionDetectionInfo);
        LambdaQueryWrapper<InspectionDetectionInfo> inspectionLambda = new QueryWrapper<InspectionDetectionInfo>().lambda();
        inspectionLambda.eq(InspectionDetectionInfo::getRecord, map.get("equipId"));
        // 更新检验检测信息
        inspectionDetectionInfoMapper.update(inspectionDetectionInfo, inspectionLambda);
        // 使用登记信息
        JgUseRegistration jgUseRegistration = new JgUseRegistration();
        LambdaQueryWrapper<OtherInfo> otherLambda = new QueryWrapper<OtherInfo>().lambda();
        otherLambda.eq(OtherInfo::getRecord, map.get("equipId"));
        OtherInfo otherInfo = otherInfoMapper.selectOne(otherLambda);
        String supervisoryCode = otherInfo.getSupervisoryCode();
        jgUseRegistration.setSupervisoryCode(supervisoryCode);
        jgUseRegistration.setUseUnitName(useInfo.getUseUnitName());
        jgUseRegistration.setUseUnitCreditCode(useInfo.getUseUnitCreditCode());
        jgUseRegistration.setUseUnitCreditCode("91610131628001738N");
        if (!ObjectUtils.isEmpty(map.get("inspectUnitCreditCode"))){
            jgUseRegistration.setInspectUnitCreditCode(map.get("inspectUnitCreditCode").toString());
        }
        if (!ObjectUtils.isEmpty(map.get("inspectOrgName"))){
            jgUseRegistration.setInspectUnitName(map.get("inspectOrgName").toString());
        }


        if (map.containsKey("type") && "edit".equals(String.valueOf(map.get("type")))) {
            jgUseRegistration.setUseUnitCreditCode(null);
            jgUseRegistration.setSequenceNbr(Long.valueOf(String.valueOf(map.get("sequenceNbr"))));
            this.getBaseMapper().updateById(jgUseRegistration);
        } else {

            // 业务管理设备信息保存
            JgUseRegistrationEq jgRelationEquip = new JgUseRegistrationEq();
            jgRelationEquip.setEquId(map.get("equipId").toString());
//            jgRelationEquip.setBusinessType(String.valueOf(BusinessTypeEnum.USAGE_REGISTRATION.getCode()));
            List<String> applicationFormCode = iCreateCodeService.createApplicationFormCode(ApplicationFormTypeEnum.SYDJ.getCode(), 1);
            jgUseRegistration.setApplyNo(applicationFormCode.get(0));
            jgUseRegistration.setAuditStatus("待提交");
            jgUseRegistration.setStatus(UseStatusEnum.SUBMIT.getPass());
            this.save(jgUseRegistration);
            jgRelationEquip.setEquipTransferId(jgUseRegistration.getSequenceNbr().toString());
            jgRelationEquipMapper.insert(jgRelationEquip);
        }

        if (!ObjectUtils.isEmpty(map.get("submit"))) {
            String instanceId = "";
            if (map.containsKey("instanceId")) {
                instanceId = map.get("instanceId").toString();
            } else {
                // 启动并执行流程
                instanceId = startByVariable();
                jgUseRegistration.setInstanceStatus("1460532889249755137");
                jgUseRegistration.setReceiveCompanyCode("610000");
            }

            if (!ObjectUtils.isEmpty(instanceId)) {
                // 执行流程
                String status = flowExecute(jgUseRegistration.getSequenceNbr(), instanceId, "0", "", true);
                jgUseRegistration.setAuditStatus("已提交");
                jgUseRegistration.setStatus(UseStatusEnum.RECEIVE.getPass());
            }
            jgUseRegistration.setInstanceId(instanceId);

            this.getBaseMapper().updateById(jgUseRegistration);
        }
    }

    public String startByVariable() {
        String instanceId = "";
        //启动流程
        try {
            ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
            dto.setProcessDefinitionKey("useRegistration");
            dto.setBusinessKey("submit");
            AjaxResult ajaxResult = Workflow.taskClient.startByVariable(dto);
            instanceId = ((Map) ajaxResult.get("data")).get("id").toString();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return instanceId;
    }

    public String flowExecute(Long id,String instanceId, String operate, String comment, Boolean update) {
        String role = "";
        String taskName = "流程结束";
        ArrayList<String> roleList = new ArrayList<>();
        try {
            JSONObject task = workFlowFeginService.getTaskNoAuth(instanceId);
            JSONObject taskMessage = JSON.parseObject(JSON.toJSONString(task.get("data")));
            String taskId = taskMessage.getString("id");
            //组装信息
            TaskResultDTO dto = new TaskResultDTO();
            dto.setResultCode("approvalStatus");
            dto.setTaskId(taskId);
            dto.setComment(comment);
            HashMap<String, Object> map = new HashMap<>();
            map.put("approvalStatus", operate);
            dto.setVariable(map);
            //执行流程
            Workflow.taskClient.completeByTask(taskId, dto);
            // 查询下节点任务
            JSONObject taskNoAuth = workFlowFeginService.getTaskNoAuth(instanceId);
            if (!ObjectUtils.isEmpty(taskNoAuth.get("data"))) {
                JSONObject nextTask = JSON.parseObject(JSON.toJSONString(taskNoAuth.get("data")));
                String nextTaskId = nextTask.getString("id");
                taskName = nextTask.getString("name");
                AjaxResult taskGroupName = Workflow.taskClient.getTaskGroupName(nextTaskId);
                JSONArray data = JSON.parseArray(JSON.toJSONString(taskGroupName.get("data")));
                for (Object datum : data) {
                    if (((Map) datum).containsKey("groupId")) {
                        roleList.add(((Map) datum).get("groupId").toString());
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        role= String.join(",", roleList);
        if (update) {
            Boolean rollBack = "1".equals(operate) ? true : false;
            updateStatus(id,instanceId, taskName, role, rollBack);
        }
        return role;
    }

    public void updateStatus(Long id , String instanceId, String taskName, String role, Boolean rollBack) {
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        LambdaQueryWrapper<JgUseRegistration> lambda = new QueryWrapper<JgUseRegistration>().lambda();
        lambda.eq(JgUseRegistration::getSequenceNbr, id);
        JgUseRegistration jgUseRegistration = this.getBaseMapper().selectOne(lambda);
        if ("流程结束".equals(taskName)) {
            jgUseRegistration.setStatus(taskName);
            jgUseRegistration.setAuditStatus("已完成");
        } else {
            jgUseRegistration.setNextExecuteIds(role);
            jgUseRegistration.setPromoter(reginParams.getUserModel().getUserId());
            if (!ObjectUtils.isEmpty(jgUseRegistration.getInstanceStatus())) {
                jgUseRegistration.setInstanceStatus(jgUseRegistration.getInstanceStatus() + "," + role);
            } else {
                jgUseRegistration.setInstanceStatus(role);
            }
            UseStatusEnum message = UseStatusEnum.getMessage(taskName);
            jgUseRegistration.setStatus(message.getPass());
        }
        if (rollBack){
            this.getBaseMapper().update(jgUseRegistration, lambda);
            this.getBaseMapper().updatePromoter(jgUseRegistration.getSequenceNbr());
        }else {
            this.getBaseMapper().update(jgUseRegistration, lambda);
        }
    }

    public void withdraw(String instanceId) {
        String taskName = "";
        JgUseRegistration jgUseRegistration = new JgUseRegistration();
        LambdaQueryWrapper<JgUseRegistration> lambda = new QueryWrapper<JgUseRegistration>().lambda();
        lambda.eq(JgUseRegistration::getInstanceId, instanceId);
        ArrayList<String> roleList = new ArrayList<>();
        try {
            workFlowFeginService.rollBack(instanceId);
            JSONObject taskNoAuth = workFlowFeginService.getTaskNoAuth(instanceId);
            JSONObject nextTask = JSON.parseObject(JSON.toJSONString(taskNoAuth.get("data")));
            taskName = nextTask.getString("name");
            if (!ObjectUtils.isEmpty(taskNoAuth.get("data"))) {
                String nextTaskId = nextTask.getString("id");
                AjaxResult taskGroupName = Workflow.taskClient.getTaskGroupName(nextTaskId);
                JSONArray data = JSON.parseArray(JSON.toJSONString(taskGroupName.get("data")));
                for (Object datum : data) {
                    if (((Map) datum).containsKey("groupId")) {
                        roleList.add(((Map) datum).get("groupId").toString());
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (!ObjectUtils.isEmpty(taskName)) {
            UseStatusEnum message = UseStatusEnum.getMessage(taskName);
            jgUseRegistration.setStatus(message.getPass());
        }

        String join = String.join(",", roleList);
        JgUseRegistration jgUseRegistration1 = this.getBaseMapper().selectOne(lambda);
        this.updateStatus(jgUseRegistration1.getSequenceNbr(), instanceId, taskName, join, true);
    }

    public void deleteBatch(List<Long> ids) {
        JgUseRegistration jgUseRegistration = new JgUseRegistration();
        jgUseRegistration.setIsDelete(true);
        LambdaQueryWrapper<JgUseRegistration> lambda = new QueryWrapper<JgUseRegistration>().lambda();
        lambda.in(JgUseRegistration::getSequenceNbr, ids);
        this.update(jgUseRegistration, lambda);
    }

    public Map<String, Object> getDetail(String id) {
        Map<String, Object> detail = this.baseMapper.getDetail(id);
        Map<String, Object> inspectDetail = this.baseMapper.getInspectDetail(id);
        Map<String, Object> useDetail = this.baseMapper.getUseDetail(id);
        detail.putAll(inspectDetail);
        detail.putAll(useDetail);
        detail.putAll(useDetail);
        detail.put("proDuctPhoto", JSON.parse(String.valueOf(detail.get("proDuctPhoto"))));
        detail.put("factoryStandard", JSON.parse(String.valueOf(detail.get("factoryStandard"))));
        detail.put("productQualityYieldProve", JSON.parse(String.valueOf(detail.get("productQualityYieldProve"))));
        detail.put("insUseMaintainExplanin", JSON.parse(String.valueOf(detail.get("insUseMaintainExplanin"))));
//        detail.put("inspectReport", JSON.parse(String.valueOf(detail.get("inspectReport"))));
        return detail;
    }

    /**
     * 参数为监管码
     * @param supervisoryCode
     * @return
     */
    public String getCode(String supervisoryCode) {
        if (!ObjectUtils.isEmpty(supervisoryCode) && supervisoryCode.length() > 5) {
            String name = EquipTypeEnum.getMessage(supervisoryCode.substring(1, 2));
            String type = supervisoryCode.substring(2, 4);
            String city = supervisoryCode.substring(0, 1);
            ResponseModel<String> stringResponseModel = tzsServiceFeignClient.useRegistrationCode(name + type + "陕" + city);
            return stringResponseModel.getResult();
        }
        return null;
    }
}