package com.yeejoin.amos.boot.module.ymt.biz.controller;

import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.ymt.api.service.IGenerateCodeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import java.util.List;

/**
 *
 * 生成顺序码
 * @author LiuLin
 * @date 2023-12-14
 */
@RestController
@Api(tags = "生成顺序码")
@RequestMapping(value = "/generate-code")
public class GenerateCodeController extends BaseController {

	@Autowired
	private IGenerateCodeService generateCodeService;

	/**
	 * 申请单编号生成
	 * @param type type
	 * @param batchSize batchSize
	 * @return List
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/applicationFormCode")
	@ApiOperation(httpMethod = "POST", value = "申请单编号生成", notes = "申请单编号生成")
	public ResponseModel<List<String>> createApplicationFormCode(@RequestParam("type") String type,
													@RequestParam("batchSize") int batchSize) {
		return ResponseHelper.buildResponse(generateCodeService.createApplicationFormCode(type,batchSize));
	}

	/**
	 * 生成设备注册编码
	 * @param key key
	 * @return String
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/deviceRegistrationCode")
	@ApiOperation(httpMethod = "POST", value = "生成设备注册编码", notes = "生成设备注册编码")
	public ResponseModel<String> createDeviceRegistrationCode(@RequestParam("key") String key) {
		return ResponseHelper.buildResponse(generateCodeService.createDeviceRegistrationCode(key));
	}

	/**
	 * 使用登记证生成
	 * @param key key
	 * @return String
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/useRegistrationCode")
	@ApiOperation(httpMethod = "POST", value = "使用登记证生成", notes = "使用登记证生成")
	public ResponseModel<String> createUseRegistrationCode(@RequestParam("key") String key) {
		return ResponseHelper.buildResponse(generateCodeService.createUseRegistrationCode(key));
	}
}
