package com.yeejoin.amos.boot.module.ugp.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.ugp.api.entity.UnitLicence;
import com.yeejoin.amos.boot.module.ugp.api.mapper.UnitLicenceMapper;
import com.yeejoin.amos.boot.module.ugp.api.service.IUnitLicenceService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import java.util.List;
import java.util.Map;

/**
 * 单位许可信息表 服务实现类
 *
 * @author duanwei
 * @date 2022-11-30
 */
@Service
public class UnitLicenceServiceImpl extends ServiceImpl<UnitLicenceMapper, UnitLicence> implements IUnitLicenceService {

    @Autowired
    OrgServiceImpl orgServiceImpl;

    public JSONObject getLicenceByCompanyId(JSONObject jsonObject,Long companyId){
        Map<String,String> installationMap = orgServiceImpl.getdetialInfo(String.valueOf(companyId));
        String creditCode = "";
        if(!ValidationUtil.isEmpty(installationMap)){
            creditCode = installationMap.get("creditCode");
        }
        if (!ValidationUtil.isEmpty(creditCode)) {
            List<UnitLicence> unitLicenceList = this.list(new LambdaQueryWrapper<UnitLicence>().eq(UnitLicence::getUnitCode,creditCode));
            if(unitLicenceList.iterator().hasNext()){
                UnitLicence unitLicence = unitLicenceList.iterator().next();
                jsonObject.put("licenseCompany",unitLicence.getUnitName());
                jsonObject.put("licenseNum",unitLicence.getCertNo());
            }
        }
        return jsonObject;
    }

}
