package com.yeejoin.amos.boot.module.common.api.feign;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.component.feign.config.InnerInvokException;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

/**
 * 防火监督服务feign
 *
 * @author Dell
 */
@FeignClient(name = "${supervision.feign.name}", path = "equip", configuration = {MultipartSupportConfig.class})
public interface SupervisionFeignClient {

    /**
     * 获取巡检隐患相关数据
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/patrol/danger/info", method = RequestMethod.GET)
    ResponseModel<Object> getPatrolDangerInfo(@RequestBody Object param);

}
