package com.yeejoin.amos.boot.module.jcs.api.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.amos.boot.module.common.api.dto.FireBrigadeResourceDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.PowerCompanyCountDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.PowerTransferCompanyDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.PowerTransferDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.PowerTransferResourceDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.PowerTransferSimpleDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.ResourceStatisticsDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.PowerTransfer;

import java.util.List;
import java.util.Map;

/**
 * 力量调派 服务类
 *
 * @author tb
 * @date 2021-06-17
 */
public interface IPowerTransferService extends IService<PowerTransfer> {

    PowerTransferSimpleDto getPowerTransferList(Long alertCalledId);

    boolean createPowerTransfer(PowerTransferDto powerTransferDto);

    List<PowerTransferCompanyDto> getLastPowerTransferCompany(Long alertCalledId);

    /**
     * 获取力量调派资源树
     */
    List<FireBrigadeResourceDto> getPowerTree();
    List<PowerCompanyCountDto> getPowerCompanyCountDtocount( Long id);

    /**
     * 根据参数查询力量调派资源列表
     *
     * @param alertCalledId 警情id
     * @param type 查询类型
     * @param page 分页参数
     * @return
     */
    IPage<PowerTransferResourceDto> getPowerTransferPageByParam(Long alertCalledId, String type, Page<PowerTransferResourceDto> page);

    /**
     * 根据参数查询力量调派资源统计信息
     *
     * @param alertCalledId 警情id
     * @param type 查询类型
     * @return
     */
    List<ResourceStatisticsDto> getPowerTransferStatistics(Long alertCalledId, String type);


    /**
     * 根据警情id获取警情调派的资源（车辆、人员、装备、车载水量、车载药剂）统计
     *
     * @param alertCalledId
     * @return
     */
    JSONObject getPowerTransferCarResourceStatistics(Long alertCalledId);

    /**
     * 获取车辆状态列表
     *
     * @return
     */
    List<Map<String, String>> getFireCarStatusList();

    /**
     * 获取调派任务状态列表
     *
     * @return
     */
    List<Map<String, String>> getDispatchTaskStatusList();
}
