package com.yeejoin.amos.supervision.business.dao.repository;

import com.yeejoin.amos.supervision.dao.entity.InputItem;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository("inputItemDao")
public interface IInputItemDao extends BaseDao<InputItem, Long> {
    @Query(value = "select * from p_input_item where org_code = ?1 and level = ?2 and is_delete =0", nativeQuery = true)
    public List<InputItem> findByLevel(String orgCode, String level);

    @Query(value = "select * from p_input_item where org_code = ?1 and level is null and is_delete =0", nativeQuery = true)
    public List<InputItem> findByLevelNull(String orgCodel);

    @Query(value = "select * from p_input_item where org_code = ?1  and is_delete =0", nativeQuery = true)
    public List<InputItem> findAllByLevel(String orgCode);

    InputItem findByOriginalId(String originalId);

    @Query(value = "select * from p_input_item where original_id in ?1  and is_delete =0", nativeQuery = true)
    List<InputItem> listByOriginalIds(List<String> originalIds);

    @Query(value = "select * from p_input_item where id in ?1  and is_delete =0", nativeQuery = true)
    List<InputItem> listByIds(List<Long> ids);

    @Query(value = "select * from p_input_item where item_no = ?1  and equipment_name = ?2 and is_delete =0", nativeQuery = true)
    List<InputItem> findByItemNoAndEquipmentName(String itemNo,String equipmentName);

    @Query(value = "select * from p_input_item where org_code = ?1 and equipment_name =?2 and is_delete =0", nativeQuery = true)
    List<InputItem> findByOrgCodeAndEquipmentName(String orgCode,String equipmentName);

    @Query(value = "select * from p_input_item where equipment_name =?1 and is_delete =0 and input_type = 1", nativeQuery = true)
    List<InputItem> findByEquipmentName(String equipmentName);

    @Query(value = "delete * from p_input_item where is not null and is_delete =0", nativeQuery = true)
    void deleteAllByEquipmentNameIsNotNull();
}
