package com.yeejoin.amos.boot.module.elevator.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Map;

/**
 * * 警情统计
 *
 * @author fengwang
 * @date 2021-08-06.
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "AlarmStatisticsDto", description = "AlarmStatisticsDto")
public class AlarmStatisticsDto {

    @ApiModelProperty(value = "我的待办数量")
    private Integer todoNum;

    @ApiModelProperty(value = "今日接警数量")
    private Long todayAlarmNum;

    @ApiModelProperty(value = "今日提交数量")
    private Long submitNum;

    @ApiModelProperty(value = "全部待办")
    private Integer allNum;

    @ApiModelProperty(value = "近七天办理数量")
    private Map<String, Long> nearlySevenDaysNum;

    @ApiModelProperty(value = "故障事件数量")
    private Long faultRescue;

    @ApiModelProperty(value = "困人救援数量")
    private Long sleepyIncident;

    @ApiModelProperty(value = "投诉建议数量")
    private Long suggestions;

}
