package com.yeejoin.amos.patrol.common.enums;


public enum PlanTaskTypeStatusEnum {

    day("dayControl",1),
    week("weeklySurvey",2),
    month("monthlyScheduling",3),
    ;

    /**
     * 名称
     */
    private String name;

    /**
     * 值
     */
    private int value;



    private PlanTaskTypeStatusEnum(String name, int value) {
        this.name = name;
        this.value = value;
    }


    public static String getName(int value) {
        for (PlanTaskTypeStatusEnum c : PlanTaskTypeStatusEnum.values()) {
            if (c.getValue() == value) {
                return c.name;
            }
        }
        return null;
    }

    public static int getValue(String name) {
        for (PlanTaskTypeStatusEnum c : PlanTaskTypeStatusEnum.values()) {
            if (c.getName().equals(name)) {
                return c.value;
            }
        }
        return -1;
    }


    public static PlanTaskTypeStatusEnum getEnum(int value) {
        for (PlanTaskTypeStatusEnum c : PlanTaskTypeStatusEnum.values()) {
            if (c.getValue() == value) {
                return c;
            }
        }
        return null;
    }


    public static PlanTaskTypeStatusEnum getEnum(String name) {
        for (PlanTaskTypeStatusEnum c : PlanTaskTypeStatusEnum.values()) {
            if (c.getName().equals(name)) {
                return c;
            }
        }
        return null;
    }



    public String getName() {
        return name;
    }


    public void setName(String name) {
        this.name = name;
    }


    public int getValue() {
        return value;
    }


    public void setValue(int value) {
        this.value = value;
    }
}
