package com.yeejoin.amos.api.openapi.face.orm.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDate;

/**
 * 气站卸液量记录表
 * @author kinky
 *
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("tm_cylinder_offloading")
public class TmCylinderOffloading extends AbstractBaseEntity{

	private static final long serialVersionUID = 1L;

	@TableField("offloading_volume")
	private String offloadingVolume;	//卸液量（单位吨）

	@TableField("credit_code")
	private String creditCode;	//对接单位统一信用代码

	@ApiModelProperty(value = "对接接口版本")
	protected String version = "v1";

	@ApiModelProperty(value = "统计同步时间 yyyy-MM-dd")
	private LocalDate statisticsSyncDate;
}
