package com.yeejoin.amos.boot.module.jg.api.dto;

import com.yeejoin.amos.boot.biz.common.annotation.FieldDisplayDefine;
import com.yeejoin.amos.boot.biz.common.annotation.Group;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 安全追溯-场内车辆
 *
 * @author system_generator
 * @date 2023-08-17
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Accessors(chain = true)
@Group(value = "tech_params_vehicle")
public class TechParamsVehicleChangeFieldDto extends BaseTechParamsFieldDto {


    @FieldDisplayDefine(value = "车架编号")
    private String frameNo;

    @FieldDisplayDefine(value = "发动机（行走电机）编号")
    private String engineNo;

    @FieldDisplayDefine(value = "额定起重量")
    private String liftingCapacity;

    @FieldDisplayDefine(value = "传动方式")
    private String transmissionMode;

    @FieldDisplayDefine(value = "自重")
    private String weight;

    @FieldDisplayDefine(value = "动力方式")
    private String powerMode;

    @FieldDisplayDefine(value = "最大运行速度")
    private String maxRunningSpeed;

    @FieldDisplayDefine(value = "工作装置空载最大起升高度")
    private String maxLiftingHeight;

    @FieldDisplayDefine(value = "气体/粉尘组别（防爆）")
    private String gasGroup;

    @FieldDisplayDefine(value = "车架结构")
    private String frameStructure;

    @FieldDisplayDefine(value = "驾驶方式")
    private String drivingMode;

    @FieldDisplayDefine(value = "空载最大运行速度")
    private String carryingIdlerMaxRunningSpeed;

    @FieldDisplayDefine(value = "设备保护等级（防爆）")
    private String protectGrade;

    @FieldDisplayDefine(value = "温度组别（防爆）")
    private String temperatureGroup;

    @FieldDisplayDefine(value = "额定载客人数")
    private Integer passengersNumber;

    @FieldDisplayDefine(value = "最大行驶坡度")
    private String maxDrivingSlope;

    @FieldDisplayDefine(value = "整车整备质量")
    private String vehicleMass;

    @FieldDisplayDefine(value = "轴距")
    private String wheelBase;

    @FieldDisplayDefine(value = "轮距（前）")
    private String trackWidthFront;

    @FieldDisplayDefine(value = "轮距（后）")
    private String trackWidthBehind;

    @FieldDisplayDefine(value = "观光列车车厢数")
    private Integer carsNumber;

    @FieldDisplayDefine(value = "观光列车每节车厢座位数")
    private Integer seatNumber;

    @FieldDisplayDefine(value = "观光列车牵引车头座位数")
    private Integer tractorSeatNumber;

    @FieldDisplayDefine(value = "空载最大起升速度")
    private String maxLiftingSpeed;

}
