package com.yeejoin.amos.boot.module.jg.biz.controller;

import com.yeejoin.amos.boot.module.jg.biz.service.impl.XiAnDataDockServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;


@RestController
@Api(tags = "西安数据对接 API")
@RequestMapping(value = "/xi-an")
public class XiAnDataDockController {

    private final XiAnDataDockServiceImpl xiAnDataDockService;

    public XiAnDataDockController(XiAnDataDockServiceImpl xiAnDataDockService) {
        this.xiAnDataDockService = xiAnDataDockService;
    }

    /**
     * 批量导入设备数据的接口
     * @param equLists 设备数据集合
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/saveEquipmentData")
    @ApiOperation(httpMethod = "POST", value = "设备批量导入", notes = "导入多个设备的数据文件")
    public ResponseModel<?> saveEquipmentData(@RequestBody List<Map<?,?>> equLists) throws Exception {
        return ResponseHelper.buildResponse(xiAnDataDockService.saveEquipmentData(equLists));
    }
}

