package com.yeejoin.amos.boot.module.statistcs.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.statistcs.biz.service.impl.EmergencyBizServiceImpl;
import com.yeejoin.amos.boot.module.ymt.api.dto.AlertCalledQueryDto;
import com.yeejoin.amos.boot.module.ymt.api.dto.AlertPaperInfoDto;
import com.yeejoin.amos.boot.module.ymt.api.dto.VoiceRecordFileDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

@RestController
@RequestMapping(value = "/dp/biz/emergency")
@Api(tags = "大屏-应急-业务API")
public class EmergencyBizController {

    private EmergencyBizServiceImpl emergencyBizService;

    public EmergencyBizController (EmergencyBizServiceImpl emergencyBizService) {
        this.emergencyBizService = emergencyBizService;
    }

    /**
     * 应急大屏使用
     *
     * @param id 主键
     * @return Object
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/detail/{id}")
    @ApiOperation(httpMethod = "GET", value = "根据id获取应急事件详细信息", notes = "根据id获取应急事件详细信息")
    public ResponseModel<Object> getDetail(@PathVariable Long id) {
        return ResponseHelper.buildResponse(emergencyBizService.getDetail(id));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/basicDetail/{id}")
    @ApiOperation(httpMethod = "GET", value = "根据id获取救援信息", notes = "根据id获取救援信息")
    public ResponseModel<Object> getBasicDetail(@PathVariable Long id) {
        return ResponseHelper.buildResponse(emergencyBizService.getBasicDetail(id));
    }

    /**
     * 应急大屏使用
     *
     * @param id 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/dispatchRecord/{id}")
    @ApiOperation(httpMethod = "GET", value = "根据id获取调派信息", notes = "根据id获取调派信息")
    public ResponseModel<Object> getDispatchRecord(@PathVariable Long id) {
        return ResponseHelper.buildResponse(emergencyBizService.getDispatchRecord(id));


    }
    /**
     * 应急大屏使用
     *
     * @param id 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/followRecords/{id}")
    @ApiOperation(httpMethod = "GET", value = "根据id获取回访信息", notes = "根据id获取回访信息")
    public ResponseModel<Object> getFollowRecords(@PathVariable Long id) {
        return ResponseHelper.buildResponse(emergencyBizService.getFollowRecords(id));
    }
    /**
     * 应急大屏使用
     *
     * @param id 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/callRecords/{id}")
    @ApiOperation(httpMethod = "GET", value = "根据id获取通话记录信息", notes = "根据id获取通话记录信息")
    public ResponseModel<Object> getCallRecords(@PathVariable Long id, @RequestParam int number, @RequestParam int size) {
        return ResponseHelper.buildResponse(emergencyBizService.getCallRecords(id, number, size));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "应急大屏使用", notes = "查询警情事件记录")
    @GetMapping("/selectRecord/dp")
    public ResponseModel<Page<AlertCalledQueryDto>> getAlertCalledRecords(AlertCalledQueryDto alertCalledQueryDto,
                                                                          @RequestParam(value = "pageNum") int pageNum,
                                                                          @RequestParam(value = "pageSize") int pageSize,
                                                                          @RequestParam(value = "cityCode") String cityCode) {
        Page<AlertCalledQueryDto> page = new Page<>();
        page.setCurrent(pageNum);
        page.setSize(pageSize);
        return ResponseHelper.buildResponse(emergencyBizService.getAlertCalledRecords(page, alertCalledQueryDto, cityCode));
    }

    /**
     * 根据警情id 查找通话记录信息
     *
     * @return VoiceRecordFileDto
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET",value = "根据id获取通话记录信息",   notes = "根据id获取通话记录信息")
    @GetMapping(value = "/voiceRecordFile/{sequenceNbr}")
    public ResponseModel<VoiceRecordFileDto> getRecordById(@PathVariable Long sequenceNbr) {
        VoiceRecordFileDto record = emergencyBizService.getRecordById(sequenceNbr);
        return ResponseHelper.buildResponse(record);
    }

    /**
     * 根据id查询
     *
     * @param id 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/alertCalled/{id}")
    @ApiOperation(httpMethod = "GET", value = "根据id查询单个警情接警填报记录", notes = "根据id查询单个警情接警填报记录")
    public ResponseModel<Object> selectOne(@PathVariable Long id) {
        return ResponseHelper.buildResponse(emergencyBizService.selectAlertCalledById(id));
    }

    /**
     *  根据regionCode 获取区域内实时警情
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getActualAlert")
    @ApiOperation(httpMethod = "GET", value = "根据regionCode 获取区域内实时警情", notes = "根据regionCode 获取区域内实时警情")
    public ResponseModel<List<AlertPaperInfoDto>> getActualAlert(@RequestParam(name = "regionCodes", required = false) List<String> regionCodes) {
        return ResponseHelper.buildResponse(emergencyBizService.getAlertPaperInfoList(emergencyBizService.authRegionCodeList(regionCodes),false));
    }
}
