package com.yeejoin.amos.boot.module.common.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.*;

@Getter
@AllArgsConstructor
public enum ZBGLEnum {
    YJCZ("应急处置","yjcz",true,null,""),
    DTGZYYZBFX("电梯故障原因占比分析","dtgzyyzbfx",false,"yjcz","dtgzyyzbfxServiceImpl"),
    DTKRSJCSFX("电梯困人事件场所分布","dtkrsjcsfx",false,"yjcz","dtkrsjcsfxServiceImpl"),
    KRJYYDQK("困人救援月度情况","krjyydqk",false,"yjcz","krjyydqkServiceImpl"),
    JDGL("监督管理","jdgl",true,null,""),
    YWBLPJSXTJ("业务办理平均时效统计","ywblpjsxtj",false,"jdgl",""),
    AQZS("安全追溯","aqzs",true,null,""),
//    YHSLQS("隐患数量趋势（近12个月）","yhslqs",false,"aqzs",""),
    AYHLXYHSLPM("按隐患类型隐患数量排名（Top10）","ayhlxyhslpm",false,"aqzs","ayhlxyhslpmServiceImpl"),
    DNZTDWYHPM("当年主体单位隐患排名（Top10）","dnztdwyhpm",false,"aqzs","dnztdwyhpmServiceImpl"),
    QP("气瓶","qp",true,null,""),
    QYAQZSTJ("区域安全指数统计","qyaqzstj",false,"qp",""),

    ;

    String name;
    String code;
    Boolean isMainBody;
    String mainBody;
    String className;

    public static List<Map<String,Object>> getEnumList() {
        List<Map<String,Object>> result = new ArrayList<>();
        for (ZBGLEnum zbglEnum : EnumSet.allOf(ZBGLEnum.class)) {
            if(zbglEnum.isMainBody){
                HashMap<String,Object> map = new HashMap<>();
                map.put("title",zbglEnum.name);
                map.put("value",zbglEnum.code);
                List<Map<String,Object>> childrenList = new ArrayList<>();
                for (ZBGLEnum childrenEnum : EnumSet.allOf(ZBGLEnum.class)) {
                    if(!childrenEnum.isMainBody && childrenEnum.mainBody.equals(zbglEnum.code)){
                        HashMap<String,Object> childrenMap = new HashMap<>();
                        childrenMap.put("title",childrenEnum.name);
                        childrenMap.put("value",childrenEnum.code);
                        childrenList.add(childrenMap);
                    }
                }
                map.put("children",childrenList);
                result.add(map);
            }
        }
        return result;
    }
}
