package com.yeejoin.amos.boot.module.jg.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@Getter
@AllArgsConstructor
public enum EquipSourceEnum {
    jg_his("历史设备", "jg_his"),

    jg("新设备", "jg");

    private final String name;

    private final String code;


    public static String getMessage(String code) {
        for (EquipSourceEnum constants : values()) {
            if (constants.getCode().equals(code)) {
                return constants.getName();
            }
        }
        return null;
    }

    public static Map<Integer,String> getName=new HashMap<>();
    public static Map<String,Integer> getCode=new HashMap<>();

    static {
        for (ConstructionEnum e : ConstructionEnum.values()){
            getName.put(e.code, e.name);
            getCode.put(e.name, e.code);
        }

    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
