package com.yeejoin.amos.boot.module.jg.api.service;

import java.util.List;
import java.util.Map;

public interface IBizDataChangeHandleStrategy {

    /**
     * 可处理的业务类型(使用登记等)
     *
     * @return 业务类型
     */
    String canHandleBizType();

    /**
     * 获取变更信息详情
     *
     * @param applyNo 单据编号
     * @param model   single, batch
     * @param bizId   设备record
     * @return 变更信息详情
     */
    Map<String, ?> getChangeDetail(String applyNo, ModelType model, String bizId);

    /**
     * 保存
     *
     * @param applyNo    单据编号
     * @param model      single, batch
     * @param changeData 变更数据
     */
    void doSave(String applyNo, ModelType model, Map<String, Object> changeData);


    /**
     * 单据方式：单个处理、批量处理
     */
    enum ModelType {
        single,
        batch
    }

    String DEFAULT_VALUE = "default";
}
