package com.yeejoin.amos.boot.module.jg.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jg.api.dto.ShCarDto;
import com.yeejoin.amos.boot.module.jg.api.entity.ShCar;
import com.yeejoin.amos.boot.module.jg.api.entity.ShCarEqu;
import com.yeejoin.amos.boot.module.jg.api.service.IShCarService;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.ShCarEquServiceImpl;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.ShCarServiceImpl;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

import org.springframework.web.bind.annotation.*;

import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

import java.util.*;

/**
 * @author system_generator
 * @date 2024-11-08
 */
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/sh-car")
public class ShCarController extends BaseController {

    @Autowired
    ShCarServiceImpl shCarServiceImpl;

    @Resource
    ShCarEquServiceImpl shCarEquServiceImpl;

    @Autowired
    IShCarService iShCarService;

    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
    public ResponseModel<ShCar> save(@RequestBody ShCar shCar) {
        shCar = shCarServiceImpl.createWithModel(shCar);
        return ResponseHelper.buildResponse(shCar);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
    public ResponseModel<ShCar> updateBySequenceNbrShCar(@RequestBody ShCar entity, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        // entity.setSequenceNbr(sequenceNbr);
        entity.setSequenceNbr(String.valueOf(sequenceNbr));
        return ResponseHelper.buildResponse(shCarServiceImpl.updateWithModel(entity));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(shCarServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个", notes = "根据sequenceNbr查询单个")
    public ResponseModel<ShCar> selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(shCarServiceImpl.queryBySeq(sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param size    每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "分页查询", notes = "分页查询")
    public ResponseModel<Page<ShCarDto>> queryForPage(@RequestParam(value = "current") int current,
                                                      @RequestParam(value = "size") int size,
                                                      ShCarDto dto) {
        Page<ShCarDto> page = new Page<>();
        page.setCurrent(current);
        page.setSize(size);
        Page<ShCarDto> shCarDtoPage = iShCarService.queryForShCarPage(page, dto);
        shCarDtoPage.getRecords().forEach(record -> {
            if ("1".equals(record.getClaimedFlag())) {
                record.setClaimedFlag("是");
            } else if ("0".equals(record.getClaimedFlag())) {
                record.setClaimedFlag("否");
            }
        });
        return ResponseHelper.buildResponse(shCarDtoPage);
    }

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "列表全部数据查询", notes = "列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<ShCar>> selectForList() {
        return ResponseHelper.buildResponse(shCarServiceImpl.queryForShCarList());
    }

    /**
     * 数据查询，校验是否是三环系统数据
     *
     * @return 结果
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "数据查询，校验是否是三环系统数据", notes = "数据查询，校验是否是三环系统数据")
    @GetMapping(value = "/searchForSanHan")
    public ResponseModel<ShCar> searchForSanHan(@RequestParam Map<?, ?> map) {
        // 检查 map 是否为空
        if (map == null || map.isEmpty()) {
            return ResponseHelper.buildResponse(new ShCar()); // 返回空对象
        }

        ShCar shCar = null;

        for (Object value : map.values()) {
            String sanHuanInputValue = String.valueOf(value);

            // 如果值为空，直接跳过
            if (ValidationUtil.isEmpty(sanHuanInputValue)) {
                continue;
            }

            // 查询 ShCar 表
            shCar = shCarServiceImpl.getBaseMapper()
                    .selectList(new LambdaQueryWrapper<ShCar>()
                            .eq(ShCar::getClaimedFlag, Boolean.FALSE)
                            .and(w -> w
                                    .eq(ShCar::getCarNumber, sanHuanInputValue)
                                    .or()
                                    .eq(ShCar::getUseRegistrationCode, sanHuanInputValue)
                                    .or()
                                    .eq(ShCar::getFrameNumber, sanHuanInputValue)
                            )
                    ).stream().findFirst().orElse(null);

            // 如果找到符合条件的 ShCar，直接返回
            if (shCar != null && !ValidationUtil.isEmpty(shCar.getSequenceNbr())) {
                return ResponseHelper.buildResponse(shCar);
            }

            // 查询 ShCarEqu 表
            Optional<ShCarEqu> carEqu = shCarEquServiceImpl.getBaseMapper()
                    .selectList(new LambdaQueryWrapper<ShCarEqu>()
                            .eq(ShCarEqu::getEquCode, sanHuanInputValue))
                    .stream().findFirst();

            // 如果 ShCarEqu 存在，继续查询 ShCar
            if (carEqu.isPresent()) {
                shCar = shCarServiceImpl.getBaseMapper()
                        .selectList(new LambdaQueryWrapper<ShCar>()
                                .eq(ShCar::getClaimedFlag, Boolean.FALSE)
                                .eq(ShCar::getSequenceNbr, carEqu.get().getCarId())
                        ).stream().findFirst().orElse(null);

                // 如果找到，直接返回
                if (shCar != null && !ValidationUtil.isEmpty(shCar.getSequenceNbr())) {
                    return ResponseHelper.buildResponse(shCar);
                }
            }
        }

        // 如果未找到，返回空对象
        return ResponseHelper.buildResponse(new ShCar());
    }


    /**
     * 认领三环系统数据
     *
     * @return result
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "认领三环系统数据", notes = "认领三环系统数据")
    @PostMapping(value = "/claim")
    public ResponseModel<Boolean> claim(@RequestBody Map<String, Object> paramMap) {
        return ResponseHelper.buildResponse(shCarServiceImpl.claim(paramMap));
    }
}
