package com.yeejoin.amos.boot.module.jg.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jg.api.entity.ShCarEqu;
import com.yeejoin.amos.boot.module.jg.api.vo.CarAndEquVo;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.ShCarEquServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

import java.util.List;

/**
 *
 * @author system_generator
 * @date 2024-11-08
 */
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/sh-car-equ")
public class ShCarEquController extends BaseController {

    @Autowired
    ShCarEquServiceImpl shCarEquServiceImpl;

    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
	public ResponseModel<ShCarEqu> save(@RequestBody ShCarEqu shCarEqu) {
		shCarEqu = shCarEquServiceImpl.createWithModel(shCarEqu);
	    return ResponseHelper.buildResponse(shCarEqu);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
	public ResponseModel<ShCarEqu> updateBySequenceNbrShCarEqu(@RequestBody ShCarEqu entity,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    // entity.setSequenceNbr(sequenceNbr);
	    entity.setSequenceNbr(String.valueOf(sequenceNbr));
	    return ResponseHelper.buildResponse(shCarEquServiceImpl.updateWithModel(entity));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(shCarEquServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个",  notes = "根据sequenceNbr查询单个")
	public ResponseModel<ShCarEqu> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(shCarEquServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "分页查询",  notes = "分页查询")
	public ResponseModel<Page<ShCarEqu>> queryForPage(@RequestParam(value = "current") int current, @RequestParam
                    (value = "size") int size) {
	    Page<ShCarEqu> page = new Page<ShCarEqu>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(shCarEquServiceImpl.queryForShCarEquPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "列表全部数据查询",   notes = "列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<ShCarEqu>> selectForList() {
	    return ResponseHelper.buildResponse(shCarEquServiceImpl.queryForShCarEquList());
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "汽车详细信息列表",   notes = "汽车详细信息列表")
	@GetMapping(value = "/selectByCarId")
	public ResponseModel<CarAndEquVo> selectByCarId(@RequestParam String carId) {
		return ResponseHelper.buildResponse(shCarEquServiceImpl.queryByCarId(carId));
	}
}
